/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.function.primitive;

import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.tuple.Tuples;

public class CharCaseFunction<V>
implements CharToObjectFunction<V> {
    private static final long serialVersionUID = 1L;
    private final MutableList<Pair<CharPredicate, CharToObjectFunction<? extends V>>> predicateFunctions = Lists.mutable.empty();
    private CharToObjectFunction<? extends V> defaultFunction;

    public CharCaseFunction() {
    }

    public CharCaseFunction(CharToObjectFunction<? extends V> newDefaultFunction) {
        this.setDefault(newDefaultFunction);
    }

    public CharCaseFunction<V> addCase(CharPredicate predicate, CharToObjectFunction<? extends V> function) {
        this.predicateFunctions.add(Tuples.pair(predicate, function));
        return this;
    }

    public CharCaseFunction<V> setDefault(CharToObjectFunction<? extends V> function) {
        this.defaultFunction = function;
        return this;
    }

    public V valueOf(char argument) {
        int localSize = this.predicateFunctions.size();
        for (int i = 0; i < localSize; ++i) {
            Pair pair = (Pair)this.predicateFunctions.get(i);
            if (!((CharPredicate)pair.getOne()).accept(argument)) continue;
            return (V)((CharToObjectFunction)pair.getTwo()).valueOf(argument);
        }
        if (this.defaultFunction != null) {
            return (V)this.defaultFunction.valueOf(argument);
        }
        return null;
    }

    public String toString() {
        return "new CharCaseFunction(" + this.predicateFunctions + ")";
    }
}

