/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef;

import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class FordiacContextMenuProvider
extends ContextMenuProvider {
    public static final String GROUP_NAVIGATE = "org.fordiac.ide.group.navigate";
    private final ZoomManager zoomManager;
    private final ActionRegistry registry;

    public FordiacContextMenuProvider(EditPartViewer viewer, ZoomManager zoomManager, ActionRegistry registry) {
        super(viewer);
        this.zoomManager = zoomManager;
        this.registry = registry;
    }

    public ActionRegistry getRegistry() {
        return this.registry;
    }

    protected ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    public void buildContextMenu(IMenuManager menu) {
        FordiacContextMenuProvider.addActionGroups(menu);
        MenuManager alignSubMenu = this.createAlignSubmenu();
        if (!alignSubMenu.isEmpty()) {
            menu.appendToGroup("group.reorganize", (IContributionItem)alignSubMenu);
        }
    }

    private MenuManager createAlignSubmenu() {
        MenuManager submenu = new MenuManager(Messages.FordiacContextMenuProvider_Align);
        IAction action = this.registry.getAction((Object)"org.eclipse.gef.align_left");
        if (action != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_center")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_right")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        submenu.add((IContributionItem)new Separator());
        action = this.registry.getAction((Object)"org.eclipse.gef.align_top");
        if (action != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_middle")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_bottom")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        return submenu;
    }

    private static void addActionGroups(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.edit"));
        menu.add((IContributionItem)new Separator(GROUP_NAVIGATE));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.copy"));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.view"));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.find"));
        menu.add((IContributionItem)new Separator("group.add"));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.save"));
        menu.add((IContributionItem)new Separator("org.eclipse.gef.group.rest"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("additions"));
    }
}

