/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.navigator.resources.nested.PathComparator;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ResourceExtensionContentProvider
extends WorkbenchContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private Viewer viewer;

    public Object[] getElements(Object element) {
        return super.getChildren(element);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IResource) {
            return super.getChildren(element);
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        block3: {
            IContainer c;
            block4: {
                try {
                    if (!(element instanceof IContainer)) break block3;
                    c = (IContainer)element;
                    if (c.isAccessible()) break block4;
                    return false;
                }
                catch (CoreException ex) {
                    WorkbenchNavigatorPlugin.getDefault().getLog().log((IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, 0, ex.getMessage(), (Throwable)ex));
                    return false;
                }
            }
            return c.members().length > 0;
        }
        return super.hasChildren(element);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = viewer;
    }

    protected void processDelta(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        TreeSet<IResource> resourcesToRefresh = new TreeSet<IResource>(new Comparator<IResource>(){
            private PathComparator pathComparator = new PathComparator();

            @Override
            public int compare(IResource arg0, IResource arg1) {
                return this.pathComparator.compare(arg0.getFullPath(), arg1.getFullPath());
            }
        });
        this.processDelta(delta, runnables, resourcesToRefresh);
        IResource currentTopLevelResource = null;
        for (IResource resource : resourcesToRefresh) {
            if (resource == null || currentTopLevelResource != null && currentTopLevelResource.getFullPath().isPrefixOf(resource.getFullPath())) continue;
            currentTopLevelResource = resource;
            runnables.add(this.getRefreshRunnable(resource));
        }
        if (runnables.isEmpty()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.runUpdates(runnables);
        } else {
            ctrl.getDisplay().asyncExec(() -> {
                Control ctrl1 = this.viewer.getControl();
                if (ctrl1 == null || ctrl1.isDisposed()) {
                    return;
                }
                this.runUpdates(runnables);
            });
        }
    }

    private void processDelta(IResourceDelta delta, Collection<Runnable> addAndRemoveRunnables, Set<IResource> toRefresh) {
        Object[] removedObjects;
        int i;
        Object[] addedObjects;
        IContainer parent;
        IResourceDelta[] affectedChildren;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        IResource resource = delta.getResource();
        IResourceDelta[] iResourceDeltaArray = affectedChildren = delta.getAffectedChildren(4);
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta affectedChild = iResourceDeltaArray[n2];
            if ((affectedChild.getFlags() & 0x8000) != 0) {
                toRefresh.add(resource);
                return;
            }
            ++n2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x9C000) != 0 && (parent = resource.getParent()) != null) {
            toRefresh.add((IResource)parent);
        }
        if ((changeFlags & 0x40000) != 0) {
            toRefresh.add(resource);
            return;
        }
        IResourceDelta[] iResourceDeltaArray2 = affectedChildren;
        int n3 = affectedChildren.length;
        n = 0;
        while (n < n3) {
            IResourceDelta affectedChild = iResourceDeltaArray2[n];
            this.processDelta(affectedChild, addAndRemoveRunnables, toRefresh);
            ++n;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        IResourceDelta[] removedChildren = delta.getAffectedChildren(2);
        if (addedChildren.length == 0 && removedChildren.length == 0) {
            return;
        }
        int numMovedFrom = 0;
        int numMovedTo = 0;
        if (addedChildren.length > 0) {
            addedObjects = new Object[addedChildren.length];
            i = 0;
            while (i < addedChildren.length) {
                addedObjects[i] = addedChildren[i].getResource();
                if ((addedChildren[i].getFlags() & 0x1000) != 0) {
                    ++numMovedFrom;
                }
                ++i;
            }
        } else {
            addedObjects = new Object[]{};
        }
        if (removedChildren.length > 0) {
            removedObjects = new Object[removedChildren.length];
            i = 0;
            while (i < removedChildren.length) {
                removedObjects[i] = removedChildren[i].getResource();
                if ((removedChildren[i].getFlags() & 0x2000) != 0) {
                    ++numMovedTo;
                }
                ++i;
            }
        } else {
            removedObjects = new Object[]{};
        }
        boolean hasRename = numMovedFrom > 0 && numMovedTo > 0;
        Runnable addAndRemove = () -> {
            if (this.viewer instanceof AbstractTreeViewer) {
                AbstractTreeViewer treeViewer = (AbstractTreeViewer)this.viewer;
                if (hasRename) {
                    treeViewer.getControl().setRedraw(false);
                }
                try {
                    if (addedObjects.length > 0) {
                        treeViewer.add((Object)resource, addedObjects);
                    }
                    if (removedObjects.length <= 0) return;
                    treeViewer.remove(removedObjects);
                    return;
                }
                finally {
                    if (hasRename) {
                        treeViewer.getControl().setRedraw(true);
                    }
                }
            } else {
                ((StructuredViewer)this.viewer).refresh((Object)resource);
            }
        };
        addAndRemoveRunnables.add(addAndRemove);
    }

    private Runnable getRefreshRunnable(IResource resource) {
        return () -> ((StructuredViewer)this.viewer).refresh((Object)resource);
    }

    private void runUpdates(Collection<Runnable> runnables) {
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    }
}

