/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import org.eclipse.fordiac.ide.model.data.WcharType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.WCharValue;
import org.eclipse.fordiac.ide.model.eval.value.WStringValue;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class WStringCharacterVariable
extends AbstractVariable<WCharValue> {
    private final Variable<WStringValue> delegate;
    private final int index;

    public WStringCharacterVariable(Variable<WStringValue> delegate, int index) {
        super(delegate.getName() + "[" + index + "]", (INamedElement)IecTypes.ElementaryTypes.WCHAR);
        this.delegate = delegate;
        this.index = index;
    }

    @Override
    public WCharValue getValue() {
        return this.delegate.getValue().charAt(this.index);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setValue(Value value) {
        void charValue;
        if (!(value instanceof WCharValue)) {
            throw this.createCastException(value);
        }
        WCharValue wCharValue = (WCharValue)value;
        WstringType type = (WstringType)this.delegate.getType();
        if (this.index > (type.isSetMaxLength() ? type.getMaxLength() : 65534)) {
            throw new StringIndexOutOfBoundsException(this.index);
        }
        this.delegate.setValue(this.delegate.getValue().withCharAt(this.index, (WCharValue)charValue));
    }

    public WcharType getType() {
        return (WcharType)super.getType();
    }
}

