/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyBitValue;
import org.eclipse.fordiac.ide.model.value.BoolValueConverter;

public final class BoolValue
implements AnyBitValue {
    public static final BoolValue FALSE = new BoolValue(false);
    public static final BoolValue TRUE = new BoolValue(true);
    public static final BoolValue DEFAULT = FALSE;
    private final boolean value;

    private BoolValue(boolean value) {
        this.value = value;
    }

    public static BoolValue toBoolValue(boolean value) {
        return new BoolValue(value);
    }

    public static BoolValue toBoolValue(Boolean value) {
        return new BoolValue(value);
    }

    public static BoolValue toBoolValue(String value) {
        return BoolValue.toBoolValue(BoolValueConverter.INSTANCE.toValue(value));
    }

    public static BoolValue toBoolValue(AnyBitValue value) {
        return BoolValue.toBoolValue(value.boolValue());
    }

    public BoolType getType() {
        return IecTypes.ElementaryTypes.BOOL;
    }

    @Override
    public boolean boolValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public int intValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoolValue other = (BoolValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return BoolValueConverter.INSTANCE.toString((Object)this.value);
    }
}

