/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelListener;

public abstract class AbstractGraphicalAnnotationModel
implements GraphicalAnnotationModel {
    private final Map<Object, Set<GraphicalAnnotation>> annotations = new ConcurrentHashMap<Object, Set<GraphicalAnnotation>>();
    private final Set<GraphicalAnnotationModelListener> listeners = ConcurrentHashMap.newKeySet();

    @Override
    public void addAnnotationModelListener(GraphicalAnnotationModelListener listener) {
        this.addAnnotationModelListener(listener, false);
    }

    @Override
    public void addAnnotationModelListener(GraphicalAnnotationModelListener listener, boolean initialEvent) {
        this.listeners.add(listener);
        if (initialEvent) {
            listener.modelChanged(new GraphicalAnnotationModelEvent(this, this.annotations.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()), Collections.emptySet(), Collections.emptySet(), this.getModificationStamp()));
        }
    }

    @Override
    public void removeAnnotationModelListener(GraphicalAnnotationModelListener listener) {
        this.listeners.remove(listener);
    }

    protected GraphicalAnnotationModelEvent fireModelChanged(GraphicalAnnotationModelEvent event) {
        this.listeners.forEach((? super T listener) -> listener.modelChanged(event));
        return event;
    }

    @Override
    public Set<Object> getAnnotatedTargets() {
        return Set.copyOf(this.annotations.keySet());
    }

    @Override
    public boolean hasAnnotations(Object target) {
        return this.annotations.containsKey(target);
    }

    @Override
    public boolean hasAnnotation(Object target, String type) {
        return this.hasAnnotation(target, (? super GraphicalAnnotation annotation) -> annotation.getType().equals(type));
    }

    @Override
    public boolean hasAnnotation(Object target, Predicate<? super GraphicalAnnotation> filter) {
        return this.annotations.getOrDefault(target, Collections.emptySet()).stream().anyMatch(filter);
    }

    @Override
    public boolean hasAnnotation(Object target, String type, Predicate<? super GraphicalAnnotation> filter) {
        return this.annotations.getOrDefault(target, Collections.emptySet()).stream().filter(annotation -> annotation.getType().equals(type)).anyMatch(filter);
    }

    @Override
    public Set<GraphicalAnnotation> getAnnotations(Object target) {
        return Set.copyOf(this.annotations.getOrDefault(target, Collections.emptySet()));
    }

    @Override
    public boolean addAnnotation(GraphicalAnnotation annotation) {
        if (this.addAnnotationInternal(annotation)) {
            this.fireModelChanged(new GraphicalAnnotationModelEvent(this, Set.of(annotation), Collections.emptySet(), Collections.emptySet(), this.getModificationStamp()));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAnnotation(GraphicalAnnotation annotation) {
        if (this.removeAnnotationInternal(annotation)) {
            this.fireModelChanged(new GraphicalAnnotationModelEvent(this, Collections.emptySet(), Set.of(annotation), Collections.emptySet(), this.getModificationStamp()));
            return true;
        }
        return false;
    }

    @Override
    public GraphicalAnnotationModelEvent removeAnnotationIf(Predicate<? super GraphicalAnnotation> filter) {
        HashSet remove = new HashSet();
        this.forEach(annotation -> {
            if (filter.test((GraphicalAnnotation)annotation)) {
                remove.add(annotation);
            }
        });
        return this.updateAnnotations(Collections.emptySet(), remove, Collections.emptySet());
    }

    @Override
    public boolean changedAnnotation(GraphicalAnnotation annotation) {
        if (this.containsAnnotation(annotation)) {
            this.fireModelChanged(new GraphicalAnnotationModelEvent(this, Collections.emptySet(), Collections.emptySet(), Set.of(annotation), this.getModificationStamp()));
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAnnotation(GraphicalAnnotation annotation) {
        return this.annotations.getOrDefault(annotation.getTarget(), Collections.emptySet()).contains(annotation);
    }

    @Override
    public void forEach(Consumer<? super GraphicalAnnotation> action) {
        this.annotations.forEach((? super K unused, ? super V values) -> values.forEach((? super T annotation) -> action.accept((GraphicalAnnotation)annotation)));
    }

    @Override
    public GraphicalAnnotationModelEvent updateAnnotations(Set<? extends GraphicalAnnotation> add, Set<? extends GraphicalAnnotation> remove, Set<? extends GraphicalAnnotation> changed) {
        HashSet<GraphicalAnnotation> added = new HashSet<GraphicalAnnotation>();
        HashSet<GraphicalAnnotation> removed = new HashSet<GraphicalAnnotation>();
        for (GraphicalAnnotation graphicalAnnotation : remove) {
            if (!this.removeAnnotationInternal(graphicalAnnotation)) continue;
            removed.add(graphicalAnnotation);
        }
        for (GraphicalAnnotation graphicalAnnotation : add) {
            if (!this.addAnnotationInternal(graphicalAnnotation)) continue;
            added.add(graphicalAnnotation);
        }
        if (added.isEmpty() && removed.isEmpty() && changed.isEmpty()) {
            return null;
        }
        return this.fireModelChanged(new GraphicalAnnotationModelEvent(this, added, removed, changed.isEmpty() ? Collections.emptySet() : Set.copyOf(changed), this.getModificationStamp()));
    }

    protected boolean addAnnotationInternal(GraphicalAnnotation annotation) {
        return this.annotations.computeIfAbsent(annotation.getTarget(), key -> ConcurrentHashMap.newKeySet()).add(annotation);
    }

    protected boolean removeAnnotationInternal(GraphicalAnnotation annotation) {
        boolean[] result = new boolean[1];
        this.annotations.computeIfPresent(annotation.getTarget(), (key, value) -> {
            blArray[0] = value.remove(annotation);
            return value.isEmpty() ? null : value;
        });
        return result[0];
    }
}

