/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.exceptions.DataTypeValueOutOfBoundsException;

public class IEC_TIME
extends IEC_ANY {
    protected long value;

    public IEC_TIME() {
        this.value = 0L;
    }

    public IEC_TIME(long initial) {
        this.value = initial;
    }

    public IEC_TIME(String initial) {
        this.fromString(initial);
    }

    private void fromString(String paValueString) throws DataTypeValueOutOfBoundsException, NumberFormatException {
        String valueString = paValueString.toLowerCase();
        if (!valueString.startsWith("t#") && !valueString.startsWith("time#")) {
            throw new DataTypeValueOutOfBoundsException("Illegal value");
        }
        valueString = valueString.split("#")[1];
        String[] temp = valueString.split("_");
        long buf = 0L;
        int i = 0;
        while (i < temp.length) {
            if (temp[i].endsWith("us")) {
                buf += Long.parseLong(temp[i].substring(0, temp[i].length() - 2));
            } else if (temp[i].endsWith("ms")) {
                buf += Long.parseLong(temp[i].substring(0, temp[i].length() - 2)) * 1000L;
            } else if (temp[i].endsWith("s")) {
                buf += Long.parseLong(temp[i].substring(0, temp[i].length() - 1)) * 1000000L;
            } else if (temp[i].endsWith("m")) {
                buf += Long.parseLong(temp[i].substring(0, temp[i].length() - 1)) * 60000000L;
            } else if (temp[i].endsWith("h")) {
                buf += Long.parseLong(temp[i].substring(0, temp[i].length() - 1)) * 3600000000L;
            } else if (temp[i].endsWith("d")) {
                buf += Long.parseLong(temp[i].substring(0, temp[i].length() - 1)) * 86400000000L;
            }
            ++i;
        }
        this.value = buf;
    }

    public IEC_TIME(DataInputStream in) {
        super(in);
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        try {
            this.value = in.readLong();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{76};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream DOS = new DataOutputStream(myOut);
        try {
            DOS.writeLong(this.value);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public boolean equals(Object data) {
        if (data instanceof IEC_TIME) {
            return ((IEC_TIME)data).value == this.value;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_TIME)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        try {
            this.fromString(source);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

