/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY_BIT;

public class IEC_BYTE
extends IEC_ANY_BIT {
    protected byte value;
    protected final int OCTETS = 1;

    public IEC_BYTE() {
        this.value = 0;
    }

    public IEC_BYTE(byte initial) {
        this.value = initial;
    }

    public IEC_BYTE(DataInputStream in) {
        super(in);
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        try {
            this.value = in.readByte();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{81};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream DOS = new DataOutputStream(myOut);
        try {
            DOS.writeByte(this.value);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        return obj instanceof IEC_BYTE && this.value == ((IEC_BYTE)obj).value;
    }

    public int hashCode() {
        return Integer.valueOf(this.value).hashCode();
    }

    public String toString() {
        return this.toHexString();
    }

    @Override
    protected String ConvertHexString() {
        return Integer.toHexString(this.value);
    }

    @Override
    protected String ConvertBinString() {
        return Integer.toBinaryString(this.value);
    }

    public String toBinString() {
        return super.toBinString(1);
    }

    public String toHexString() {
        return super.toHexString(1);
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_BYTE)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        try {
            this.value = Byte.parseByte(source);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

