/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.DataInputStream;
import java.util.Hashtable;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ARRAY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_BOOL;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_BYTE;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_DATE;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_DATE_AND_TIME;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_DINT;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_DWORD;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_INT;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_LINT;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_LREAL;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_LWORD;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_REAL;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_SINT;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_STRING;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_TIME;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_TIME_OF_DAY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_UDINT;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_UINT;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_USINT;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_WORD;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_WSTRING;
import org.eclipse.fordiac.ide.util.comm.datatypes.derived.DerivedDataTypeFactory;
import org.eclipse.fordiac.ide.util.comm.exceptions.DataTypeValueOutOfBoundsException;

public class IECDataTypeFactory {
    private static final Hashtable<String, Integer> ASN1map = new Hashtable();

    static {
        ASN1map.put("BOOL", 65);
        ASN1map.put("SINT", 66);
        ASN1map.put("INT", 67);
        ASN1map.put("DINT", 68);
        ASN1map.put("LINT", 69);
        ASN1map.put("USINT", 70);
        ASN1map.put("UINT", 71);
        ASN1map.put("UDINT", 72);
        ASN1map.put("ULINT", 73);
        ASN1map.put("REAL", 74);
        ASN1map.put("LREAL", 75);
        ASN1map.put("DATE", 77);
        ASN1map.put("TIME", 76);
        ASN1map.put("TIME_OF_DAY", 78);
        ASN1map.put("DATE_AND_TIME", 79);
        ASN1map.put("STRING", 80);
        ASN1map.put("WSTRING", 85);
        ASN1map.put("BYTE", 81);
        ASN1map.put("WORD", 82);
        ASN1map.put("DWORD", 83);
        ASN1map.put("LWORD", 84);
        ASN1map.put("ANY", 80);
    }

    public static IEC_ANY getIECTypeByTypename(String TypeName) {
        Integer key = ASN1map.get(TypeName);
        if (key != null) {
            switch (key) {
                case 65: {
                    return new IEC_BOOL(false);
                }
                case 66: {
                    return new IEC_SINT(0);
                }
                case 67: {
                    return new IEC_INT(0);
                }
                case 68: {
                    return new IEC_DINT(0);
                }
                case 69: {
                    return new IEC_LINT(0);
                }
                case 70: {
                    return new IEC_USINT(0);
                }
                case 71: {
                    return new IEC_UINT(0);
                }
                case 72: {
                    return new IEC_UDINT(0L);
                }
                case 73: {
                    throw new DataTypeValueOutOfBoundsException("Data type ULINT not supported.");
                }
                case 74: {
                    return new IEC_REAL(0.0f);
                }
                case 75: {
                    return new IEC_LREAL(0.0);
                }
                case 76: {
                    return new IEC_TIME();
                }
                case 77: {
                    return new IEC_DATE();
                }
                case 78: {
                    return new IEC_TIME_OF_DAY();
                }
                case 79: {
                    return new IEC_DATE_AND_TIME();
                }
                case 80: {
                    return new IEC_STRING();
                }
                case 81: {
                    return new IEC_BYTE();
                }
                case 82: {
                    return new IEC_WORD();
                }
                case 83: {
                    return new IEC_DWORD();
                }
                case 84: {
                    return new IEC_LWORD();
                }
                case 85: {
                    return new IEC_WSTRING();
                }
            }
        }
        return null;
    }

    public static IEC_ANY getIECType(int IdentifierOctet, DataInputStream in) {
        switch (IdentifierOctet) {
            case 5: {
                return null;
            }
            case 64: {
                return new IEC_BOOL(false);
            }
            case 65: {
                return new IEC_BOOL(true);
            }
            case 66: {
                return new IEC_SINT(in);
            }
            case 67: {
                return new IEC_INT(in);
            }
            case 68: {
                return new IEC_DINT(in);
            }
            case 69: {
                return new IEC_LINT(in);
            }
            case 70: {
                return new IEC_USINT(in);
            }
            case 71: {
                return new IEC_UINT(in);
            }
            case 72: {
                return new IEC_UDINT(in);
            }
            case 73: {
                throw new DataTypeValueOutOfBoundsException("Data type ULINT not supported.");
            }
            case 74: {
                return new IEC_REAL(in);
            }
            case 75: {
                return new IEC_LREAL(in);
            }
            case 76: {
                return new IEC_TIME(in);
            }
            case 77: {
                return new IEC_DATE(in);
            }
            case 78: {
                return new IEC_TIME_OF_DAY(in);
            }
            case 79: {
                return new IEC_DATE_AND_TIME(in);
            }
            case 80: {
                return new IEC_STRING(in);
            }
            case 81: {
                return new IEC_BYTE(in);
            }
            case 82: {
                return new IEC_WORD(in);
            }
            case 83: {
                return new IEC_DWORD(in);
            }
            case 84: {
                return new IEC_LWORD(in);
            }
            case 85: {
                return new IEC_WSTRING(in);
            }
            case 118: {
                return new IEC_ARRAY(in);
            }
        }
        return DerivedDataTypeFactory.getDerivedType(IdentifierOctet, in);
    }
}

