/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.imageprovider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public enum FordiacImage {
    Missing,
    Image_4DIACAbout,
    ICON_4DIAC_16,
    ICON_4DIAC_32,
    ICON_Adapter,
    ICON_Algorithm,
    ICON_Application,
    ICON_BasicFB,
    ICON_BreakPoint,
    ICON_BreakpointsView,
    ICON_ClearDevice,
    ICON_ClearForce,
    ICON_CompositeFB,
    ICON_Data,
    ICON_DataInput,
    ICON_DataType,
    ICON_DataOutput,
    ICON_DeleteResource,
    ICON_DeploymentConsole,
    ICON_DeploymentPerspective,
    ICON_Device,
    ICON_Download,
    ICON_DownloadSelectionTreeView,
    ICON_ECAction,
    ICON_ECC,
    ICON_ECState,
    ICON_Event,
    ICON_EventInput,
    ICON_EventOutput,
    ICON_ExpandAll,
    ICON_Export,
    ICON_FB,
    ICON_FBNetwork,
    ICON_FBTest,
    ICON_FBTester,
    ICON_FirmwareResource,
    ICON_ForceValue,
    ICON_HideData,
    ICON_HideEvent,
    ICON_InterfaceEditor,
    ICON_InterfaceList,
    ICON_KillDevice,
    ICON_RuntimeLauncher,
    ICON_LeftInputPrimitive,
    ICON_LeftOutputPrimitive,
    ICON_LinkOutput,
    ICON_LinkInput,
    ICON_LockedState,
    ICON_MonitoringDecorator,
    ICON_MonitoringPerspective,
    ICON_NoTest,
    ICON_OK,
    ICON_Plugs,
    ICON_Properties,
    ICON_Refresh,
    ICON_RemoveWatch,
    ICON_Resource,
    ICON_Resume,
    ICON_RigthInputPrimitive,
    ICON_RigthOutputPrimitive,
    ICON_RundDebug,
    ICON_SaveImage,
    ICON_SaveImageDisabled,
    ICON_Segment,
    ICON_Service,
    ICON_ServiceSequence,
    ICON_SIFB,
    ICON_SubApp,
    ICON_Sockets,
    ICON_Start,
    ICON_StartMonitoring,
    ICON_Stop,
    ICON_StructuredText,
    ICON_System,
    ICON_SystemConfiguration,
    ICON_SystemExplorer,
    ICON_SystemPerspective,
    ICON_TesterTemplate,
    ICON_TestFailed,
    ICON_TestOK,
    ICON_ToggleBreakpoint,
    ICON_Tools,
    ICON_TypeNavigator,
    ICON_Transaction,
    ICON_TriggerEvent,
    ICON_Variables,
    ICON_WatchesView,
    ICON_WatchInterfaceElements,
    OVERLAY_DistributedNature;

    private static final String IMAGES_DIRECTORY = "images";
    private static final String FORDIAC_IMAGE_PROPERTIES = "fordiacimages";
    private static ResourceBundle foridacImageProperties;
    private static Hashtable<Image, Image> errorImages;
    private static int count;

    static {
        foridacImageProperties = ResourceBundle.getBundle(FORDIAC_IMAGE_PROPERTIES);
        errorImages = new Hashtable();
        count = 0;
    }

    public static Image getErrorOverlayImage(Image image) {
        if (image == null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
        }
        if (!errorImages.containsKey(image)) {
            DecorationOverlayIcon overlay = new DecorationOverlayIcon(image, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR"), 0);
            System.out.println("createErrorOverlayImage " + ++count);
            errorImages.put(image, overlay.createImage());
        }
        return errorImages.get(image);
    }

    public Image getImage() {
        Image image = JFaceResources.getImageRegistry().get(this.name());
        if (image == null) {
            image = FordiacImage.addImageDescriptor(this.name()) ? JFaceResources.getImageRegistry().get(this.name()) : FordiacImage.getErrorImage();
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor id = JFaceResources.getImageRegistry().getDescriptor(this.name());
        if (id == null) {
            id = FordiacImage.addImageDescriptor(this.name()) ? JFaceResources.getImageRegistry().getDescriptor(this.name()) : FordiacImage.getErrorImageDescriptor();
        }
        return id;
    }

    public InputStream getImageAsInputStream() throws IOException {
        InputStream ret = null;
        URL fileLocation = FordiacImage.getImageURL(this.name());
        ret = fileLocation != null ? fileLocation.openConnection().getInputStream() : Missing.getImageAsInputStream();
        return ret;
    }

    private static boolean addImageDescriptor(String name) {
        try {
            URL fileLocation = FordiacImage.getImageURL(name);
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)fileLocation);
            JFaceResources.getImageRegistry().put(name, id);
        }
        catch (IllegalArgumentException | MissingResourceException runtimeException) {
            return false;
        }
        return true;
    }

    private static URL getImageURL(String name) {
        String fileName = foridacImageProperties.getString(name);
        return FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("images/" + fileName), null);
    }

    private static Image getErrorImage() {
        ISharedImages si = PlatformUI.getWorkbench().getSharedImages();
        return si.getImage("IMG_OBJS_ERROR_TSK");
    }

    private static ImageDescriptor getErrorImageDescriptor() {
        ISharedImages si = PlatformUI.getWorkbench().getSharedImages();
        return si.getImageDescriptor("IMG_OBJS_ERROR_TSK");
    }

    public static DecorationOverlayIcon createOverlayImage(Image image, ImageDescriptor imageDescriptor) {
        return FordiacImage.createOverlayImage(image, imageDescriptor, 0);
    }

    public static DecorationOverlayIcon createOverlayImage(Image image, ImageDescriptor imageDescriptor, int quadrant) {
        return new DecorationOverlayIcon(image, imageDescriptor, quadrant);
    }
}

