/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.ui.controls.IFileChanged;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileChooserControl
extends Composite {
    private Text text = null;
    private final String labelText;
    private final String[] filterNames;
    private final String[] filterExtensions;
    private List<IFileChanged> listeners = new ArrayList<IFileChanged>();

    public FileChooserControl(Composite parent, int style, String label, String[] filterNames, String[] filterExtensions) {
        super(parent, style);
        this.labelText = label;
        this.filterNames = (String[])filterNames.clone();
        this.filterExtensions = (String[])filterExtensions.clone();
        this.initialize();
    }

    private void initialize() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        CLabel cLabel = new CLabel((Composite)this, 0);
        cLabel.setText(this.labelText);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)gridData);
        Button button = new Button((Composite)this, 0);
        button.setText("Select");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedFile;
                FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                String dir = FileChooserControl.this.text.getText();
                dialog.setText(FileChooserControl.this.labelText);
                dialog.setFilterExtensions(FileChooserControl.this.filterExtensions);
                dialog.setFilterNames(FileChooserControl.this.filterNames);
                if (!dir.equals("")) {
                    dialog.setFilterPath(dir);
                }
                if ((selectedFile = dialog.open()) != null) {
                    FileChooserControl.this.text.setText(selectedFile);
                    FileChooserControl.this.notifyFileListeners();
                }
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    FileChooserControl.this.notifyFileListeners();
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                FileChooserControl.this.notifyFileListeners();
            }
        });
        this.setLayout((Layout)gridLayout);
    }

    public void addFileChangedListener(IFileChanged listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeFileChangedListener(IFileChanged listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void notifyFileListeners() {
        for (IFileChanged l : this.listeners) {
            l.fileChanged(this.text.getText());
        }
    }

    public String getFile() {
        return this.text.getText();
    }

    public void setFile(String dir) {
        if (dir != null && !dir.equals(this.text.getText())) {
            this.text.setText(dir);
            this.notifyFileListeners();
        }
    }
}

