/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.controls;

import java.util.ArrayList;
import org.eclipse.fordiac.ide.ui.controls.IDirectoryChanged;
import org.eclipse.fordiac.ide.ui.controls.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DirectoryChooserControl
extends Composite {
    private CLabel cLabel = null;
    private Text text = null;
    private Button button = null;
    private final String labelText;
    ArrayList<IDirectoryChanged> listeners = new ArrayList();

    public DirectoryChooserControl(Composite parent, int style, String label) {
        super(parent, style);
        this.labelText = label;
        this.initialize(false);
    }

    private void initialize(boolean useLabel) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        this.cLabel = new CLabel((Composite)this, 0);
        if (useLabel) {
            this.cLabel.setText(this.labelText);
        } else {
            this.cLabel.setText(Messages.DirectoryChooserControl_LABEL_ChooseDirectory);
        }
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)gridData);
        this.button = new Button((Composite)this, 0);
        this.button.setText(Messages.DirectoryChooserControl_LABEL_Browse);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedDirectory;
                DirectoryDialog dialog = new DirectoryDialog(Display.getDefault().getActiveShell(), 8192);
                String dir = DirectoryChooserControl.this.text.getText();
                dialog.setText(DirectoryChooserControl.this.labelText);
                dialog.setMessage(Messages.DirectoryChooserControl_LABEL_SelectdDirectoryDialogMessage);
                if (!dir.equals("")) {
                    dialog.setFilterPath(dir);
                }
                if ((selectedDirectory = dialog.open()) != null) {
                    DirectoryChooserControl.this.text.setText(selectedDirectory);
                    DirectoryChooserControl.this.notifyDirectoryListeners();
                }
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    DirectoryChooserControl.this.notifyDirectoryListeners();
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DirectoryChooserControl.this.notifyDirectoryListeners();
            }
        });
        this.setLayout((Layout)gridLayout);
    }

    public void addDirectoryChangedListener(IDirectoryChanged listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeDirectoryChangedListener(IDirectoryChanged listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void notifyDirectoryListeners() {
        for (IDirectoryChanged l : this.listeners) {
            l.directoryChanged(this.text.getText());
        }
    }

    public String getDirectory() {
        return this.text.getText();
    }

    public void setDirectory(String dir) {
        this.text.setText(dir);
    }
}

