/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.NewApplicationWizard;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.NewSystemPage;
import org.eclipse.fordiac.ide.systemmanagement.util.SystemPaletteManagement;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewSystemWizard
extends Wizard
implements INewWizard {
    private NewSystemPage page;

    public NewSystemWizard() {
        this.setWindowTitle(Messages.NewSystemWizard_WizardName);
    }

    public void addPages() {
        this.page = new NewSystemPage(Messages.NewSystemWizard_WizardName);
        this.page.setTitle(Messages.NewSystemWizard_WizardName);
        this.page.setDescription(Messages.NewSystemWizard_WizardDesc);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    NewSystemWizard.this.createProject((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    protected String[] getNatureIDs() {
        return new String[]{"org.eclipse.fordiac.ide.systemmanagement.FordiacNature"};
    }

    public AutomationSystem createProject(IProgressMonitor monitor) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String projectName = this.page.getProjectName();
            boolean defaultPalette = this.page.importDefaultPalette();
            IPath location = this.page.getLocationPath();
            IProject project = root.getProject(projectName);
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
            if (!Platform.getLocation().equals((Object)location)) {
                description.setLocation(location);
            }
            description.setNatureIds(this.getNatureIDs());
            project.create(description, monitor);
            project.open(monitor);
            if (defaultPalette) {
                SystemPaletteManagement.copyToolTypeLibToProject((IProject)project);
            }
            AutomationSystem system = SystemManager.INSTANCE.createAutomationSystem(project);
            NewSystemWizard.setupVersionInfo(system);
            SystemManager.INSTANCE.addSystem(system);
            NewApplicationWizard.performApplicationCreation(system, this.page.getInitialApplicationName(), this.page.getOpenApplication(), this.getShell());
            SystemManager.INSTANCE.saveSystem(system);
            AutomationSystem automationSystem = system;
            return automationSystem;
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
        return null;
    }

    private static void setupVersionInfo(AutomationSystem system) {
        VersionInfo verInfo = LibraryElementFactory.eINSTANCE.createVersionInfo();
        verInfo.setAuthor("Author");
        verInfo.setOrganization("Eclipse 4diac");
        verInfo.setVersion("1.0");
        system.getVersionInfo().add((Object)verInfo);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

