/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameApplication
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Application application;
        String newName;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection && ((TreeSelection)selection).getFirstElement() instanceof Application && (newName = RenameApplication.showRenameDialog(application = (Application)((TreeSelection)selection).getFirstElement())) != null) {
            RenameApplication.performApplicationRename(application, newName);
        }
        return null;
    }

    private static String showRenameDialog(final Application application) {
        InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), "Rename Application", "Enter new application name", application.getName(), new IInputValidator(){

            public String isValid(String newText) {
                if (application.getName().equals(newText)) {
                    return new String("Application name not different!");
                }
                if (!NameRepository.isValidName((INamedElement)application, (String)newText)) {
                    return Messages.NewApplicationPage_ErrorMessageInvalidAppName;
                }
                return null;
            }
        }){

            protected Control createDialogArea(Composite parent) {
                Control retval = super.createDialogArea(parent);
                this.getText().addVerifyListener((VerifyListener)new IdentifierVerifyListener());
                return retval;
            }
        };
        int ret = dialog.open();
        if (ret == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private static void performApplicationRename(Application application, String newName) {
        ChangeNameCommand cmd = new ChangeNameCommand((INamedElement)application, newName);
        CommandStack cmdStack = SystemManager.INSTANCE.getCommandStack(application.getAutomationSystem());
        cmdStack.execute((Command)cmd);
    }
}

