/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.views;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.monitoring.actions.BreakpointsViewContinueBreakpoint;
import org.eclipse.fordiac.ide.monitoring.provider.BreakpointsContentProvider;
import org.eclipse.fordiac.ide.monitoring.provider.BreakpointsLabelProvider;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class BreakpointsView
extends ViewPart {
    private FilteredTree filteredTree;
    private final EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            BreakpointsView.this.filteredTree.getViewer().refresh(true);
        }
    };
    private Action continueAction;

    public void createPartControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        PatternFilter patternFilter = new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                return super.isElementVisible(viewer, element);
            }

            protected boolean isParentMatch(Viewer viewer, Object element) {
                return super.isParentMatch(viewer, element);
            }
        };
        this.filteredTree = new FilteredTree(root, 800, patternFilter, true);
        GridData treeGridData = new GridData();
        treeGridData.grabExcessHorizontalSpace = true;
        treeGridData.grabExcessVerticalSpace = true;
        treeGridData.horizontalAlignment = 4;
        treeGridData.verticalAlignment = 4;
        this.filteredTree.setLayoutData((Object)treeGridData);
        TreeViewerColumn column1 = new TreeViewerColumn(this.filteredTree.getViewer(), 0);
        column1.getColumn().setText("Breakpoint");
        column1.getColumn().setWidth(340);
        TreeViewerColumn column2 = new TreeViewerColumn(this.filteredTree.getViewer(), 0);
        column2.getColumn().setText("Condition");
        column2.getColumn().setWidth(100);
        column2.setEditingSupport(new EditingSupport(column2.getViewer()){

            protected void setValue(Object element, Object value) {
                if (element instanceof MonitoringElement) {
                    ((MonitoringElement)element).setBreakpointCondition(value.toString());
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof MonitoringElement) {
                    return ((MonitoringElement)element).getBreakpointCondition();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)BreakpointsView.this.filteredTree.getViewer().getTree());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.filteredTree.getViewer().getTree().setHeaderVisible(true);
        this.filteredTree.getViewer().getTree().setLinesVisible(true);
        this.filteredTree.getViewer().setContentProvider((IContentProvider)new BreakpointsContentProvider());
        this.filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new BreakpointsLabelProvider());
        this.filteredTree.getViewer().setInput(new Object());
        this.filteredTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object first;
                if (BreakpointsView.this.filteredTree.getViewer().getSelection() instanceof IStructuredSelection && (first = ((IStructuredSelection)BreakpointsView.this.filteredTree.getViewer().getSelection()).getFirstElement()) instanceof MonitoringElement) {
                    boolean active = ((MonitoringElement)first).isBreakpointActive();
                    BreakpointsView.this.continueAction.setEnabled(active);
                }
            }
        });
        this.addBreakpointAdapters();
        this.createToolbarbuttons();
    }

    private void addBreakpointAdapters() {
        MonitoringManager.getInstance().addBreakpointsAdapter(this.adapter);
    }

    private void createToolbarbuttons() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action refresh = new Action(){

            public void run() {
                BreakpointsView.this.filteredTree.getViewer().refresh();
            }
        };
        refresh.setText("Refresh");
        refresh.setToolTipText("Refresh");
        refresh.setImageDescriptor(FordiacImage.ICON_Refresh.getImageDescriptor());
        toolBarManager.add((IAction)refresh);
        this.continueAction = new Action(){

            public void run() {
                BreakpointsViewContinueBreakpoint bla = new BreakpointsViewContinueBreakpoint();
                bla.selectionChanged((IAction)BreakpointsView.this.continueAction, BreakpointsView.this.filteredTree.getViewer().getSelection());
                bla.run((IAction)BreakpointsView.this.continueAction);
            }
        };
        this.continueAction.setText("Continue");
        this.continueAction.setToolTipText("Continue");
        this.continueAction.setImageDescriptor(FordiacImage.ICON_Resume.getImageDescriptor());
        this.continueAction.setEnabled(false);
        toolBarManager.add((IAction)this.continueAction);
    }

    public void setFocus() {
    }
}

