/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.model.monitoring.PortElement;
import org.eclipse.fordiac.ide.monitoring.DevicePolling;
import org.eclipse.fordiac.ide.monitoring.DisableSystemMonitoringRunnable;
import org.eclipse.fordiac.ide.monitoring.EnableSystemMonitoringRunnable;
import org.eclipse.fordiac.ide.monitoring.communication.TCPCommunicationObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class SystemMonitoringData {
    private final AutomationSystem system;
    private final Map<IInterfaceElement, MonitoringBaseElement> monitoredElements = new Hashtable<IInterfaceElement, MonitoringBaseElement>();
    private final Map<String, MonitoringBaseElement> monitoredElementsPerPortStrings = new Hashtable<String, MonitoringBaseElement>();
    private final Hashtable<Device, TCPCommunicationObject> openCommunication = new Hashtable();
    private final Hashtable<Device, DevicePolling> pollingThreads = new Hashtable();
    private boolean monitoringEnabled = false;

    public SystemMonitoringData(AutomationSystem system) {
        this.system = system;
    }

    AutomationSystem getSystem() {
        return this.system;
    }

    Collection<MonitoringBaseElement> getMonitoredElements() {
        return this.monitoredElements.values();
    }

    TCPCommunicationObject getCommObject(Device dev) {
        return this.openCommunication.get(dev);
    }

    void addCommObject(Device dev, TCPCommunicationObject comObj) {
        this.openCommunication.put(dev, comObj);
    }

    DevicePolling getPollingThread(Device dev) {
        return this.pollingThreads.get(dev);
    }

    void addPollingThread(Device dev, DevicePolling thread) {
        this.pollingThreads.put(dev, thread);
    }

    void removePollingThread(Device dev) {
        this.pollingThreads.remove(dev);
    }

    public void enableSystem() {
        EnableSystemMonitoringRunnable enable = new EnableSystemMonitoringRunnable(this);
        Shell shell = Display.getDefault().getActiveShell();
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, (IRunnableWithProgress)enable);
            this.monitoringEnabled = true;
        }
        catch (InvocationTargetException ex) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)ex.getMessage());
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)shell, (String)"Enable Monitoring Aborted", (String)"Enable Monitoring Aborted");
        }
    }

    public void disableSystem() {
        DisableSystemMonitoringRunnable disable = new DisableSystemMonitoringRunnable(this);
        Shell shell = Display.getDefault().getActiveShell();
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, (IRunnableWithProgress)disable);
            this.monitoringEnabled = false;
        }
        catch (InvocationTargetException ex) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)ex.getMessage());
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)shell, (String)"Disable Monitoring Aborted", (String)"Disable Monitoring Aborted");
        }
    }

    public MonitoringBaseElement getMonitoringElementByPortString(String portString) {
        return this.monitoredElementsPerPortStrings.get(portString);
    }

    public void sendRemoveWatch(MonitoringBaseElement element) {
        TCPCommunicationObject commObject = this.getCommObject(element.getPort().getDevice());
        if (commObject != null) {
            commObject.removeWatch(element);
        }
    }

    public void sendAddWatch(MonitoringBaseElement element) {
        TCPCommunicationObject commObject = this.getCommObject(element.getPort().getDevice());
        if (commObject != null) {
            commObject.addWatch(element);
        }
    }

    public boolean monitoringForSystemEnabled() {
        return this.monitoringEnabled;
    }

    public void removeMonitoringElement(MonitoringBaseElement element) {
        PortElement port = element.getPort();
        if (element instanceof MonitoringElement) {
            this.sendRemoveWatch(element);
        }
        this.monitoredElements.remove(port.getInterfaceElement());
        this.monitoredElementsPerPortStrings.remove(port.getPortString());
    }

    public void addMonitoringElement(MonitoringBaseElement element) {
        PortElement port = element.getPort();
        this.monitoredElements.put(port.getInterfaceElement(), element);
        this.monitoredElementsPerPortStrings.put(port.getPortString(), element);
        if (element instanceof MonitoringElement) {
            this.sendAddWatch(element);
        }
    }

    public MonitoringBaseElement getMonitoredElement(IInterfaceElement port) {
        return this.monitoredElements.get(port);
    }
}

