/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.DevicePolling;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.fordiac.ide.monitoring.communication.TCPCommunicationObject;
import org.eclipse.jface.operation.IRunnableWithProgress;

class DisableSystemMonitoringRunnable
implements IRunnableWithProgress {
    private final SystemMonitoringData systemMonitoringData;

    public DisableSystemMonitoringRunnable(SystemMonitoringData systemMonitoringData) {
        this.systemMonitoringData = systemMonitoringData;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        EList devices = this.systemMonitoringData.getSystem().getSystemConfiguration().getDevices();
        int count = devices.size() * 2;
        monitor.beginTask("Disable monitoring for system", count += this.systemMonitoringData.getMonitoredElements().size());
        this.stopPollingThreads(monitor);
        this.removeWatches(monitor);
        this.disconnectFromDevices((List<Device>)devices, monitor);
        monitor.done();
    }

    private void disconnectFromDevices(List<Device> devices, IProgressMonitor monitor) {
        monitor.subTask("Disconnecting the devices");
        for (Device dev : devices) {
            if (monitor.isCanceled()) break;
            TCPCommunicationObject commObject = this.systemMonitoringData.getCommObject(dev);
            if (commObject != null) {
                commObject.disable();
            }
            monitor.worked(1);
        }
    }

    private void removeWatches(IProgressMonitor monitor) {
        monitor.subTask("Connecting to the devices");
        for (MonitoringBaseElement element : this.systemMonitoringData.getMonitoredElements()) {
            if (monitor.isCanceled()) break;
            if (!(element instanceof MonitoringElement)) continue;
            monitor.subTask("Remove watch for: " + element.getPortString());
            this.systemMonitoringData.sendRemoveWatch(element);
            monitor.worked(1);
        }
    }

    private void stopPollingThreads(IProgressMonitor monitor) {
        monitor.subTask("Enabling the polling threads");
        for (Device dev : this.systemMonitoringData.getSystem().getSystemConfiguration().getDevices()) {
            if (monitor.isCanceled()) break;
            DevicePolling t = this.systemMonitoringData.getPollingThread(dev);
            if (t != null) {
                t.setRunning(false);
                this.systemMonitoringData.removePollingThread(dev);
            }
            monitor.worked(1);
        }
    }
}

