/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.ParseException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.CompilableElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.ReferencedTypeNotFoundException;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubAppTImporter
extends FBTImporter {
    public void setPalette(Palette palette) {
        this.palette = palette;
    }

    public SubAppType importSubAppType(IFile subapptFile, Palette palette) throws ReferencedTypeNotFoundException {
        FBType newType = this.importType(subapptFile, palette);
        if (newType != null && this.type instanceof SubAppType) {
            return (SubAppType)this.type;
        }
        return null;
    }

    @Override
    protected FBType createType() {
        return LibraryElementFactory.eINSTANCE.createSubAppType();
    }

    @Override
    protected FBType parseType(Node rootNode) throws TypeImportException, ReferencedTypeNotFoundException, ParseException {
        if (rootNode.getNodeName().equals("SubAppType")) {
            CommonElementImporter.readNameCommentAttributes(this.type, rootNode.getAttributes());
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("Identification")) {
                    this.type.setIdentification(CommonElementImporter.parseIdentification(this.type, n));
                }
                if (n.getNodeName().equals("VersionInfo")) {
                    this.type.getVersionInfo().add((Object)CommonElementImporter.parseVersionInfo(this.type, n));
                }
                if (n.getNodeName().equals("CompilerInfo")) {
                    this.type.setCompilerInfo(CompilableElementImporter.parseCompilerInfo(this.type, n));
                }
                if (n.getNodeName().equals("SubAppInterfaceList")) {
                    this.type.setInterfaceList(this.parseInterfaceList(n));
                }
                if (n.getNodeName().equals("Service")) {
                    this.parseService(this.type, n);
                }
                if (n.getNodeName().equals("SubAppNetwork")) {
                    ((SubAppType)this.type).setFBNetwork(new SubAppNetworkImporter(this.palette, this.type.getInterfaceList()).parseFBNetwork(n));
                }
                ++i;
            }
            return this.type;
        }
        throw new ParseException(Messages.SubAppTImporter_ERROR, 0);
    }

    @Override
    protected String getEventOutputElement() {
        return "SubAppEventOutputs";
    }

    @Override
    protected String getEventInputElement() {
        return "SubAppEventInputs";
    }

    @Override
    protected String getEventElement() {
        return "SubAppEvent";
    }

    @Override
    public void parseWithConstructs(NodeList childNodes, Map<String, Event> eventInputs, Map<String, Event> eventOutputs, Map<String, VarDeclaration> variables) {
    }
}

