/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.CompilableType;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Language;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompilableElementImporter {
    public static CompilerInfo parseCompilerInfo(CompilableType ctype, Node node) throws TypeImportException {
        Node classdef;
        NamedNodeMap map = node.getAttributes();
        CompilerInfo compilerInfo = LibraryElementFactory.eINSTANCE.createCompilerInfo();
        ctype.setCompilerInfo(compilerInfo);
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node compiler = childNodes.item(i);
            if (compiler.getNodeName().equals("Compiler")) {
                CompilableElementImporter.parseCompiler(compilerInfo, compiler);
            }
            ++i;
        }
        Node header = map.getNamedItem("header");
        if (header != null) {
            compilerInfo.setHeader(header.getNodeValue());
        }
        if ((classdef = map.getNamedItem("classdef")) != null) {
            compilerInfo.setClassdef(classdef.getNodeValue());
        }
        return compilerInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseCompiler(CompilerInfo compilerInfo, Node compiler) throws TypeImportException {
        NamedNodeMap map = compiler.getAttributes();
        Compiler comp = LibraryElementFactory.eINSTANCE.createCompiler();
        Node language = map.getNamedItem("Language");
        if (language == null) throw new TypeImportException(Messages.CompilableElementImporter_ERROR_LanguageNotDefined);
        if (language.getNodeValue().toUpperCase().equals("C")) {
            comp.setLanguage(Language.C);
        } else if (language.getNodeValue().toUpperCase().equals("CPP")) {
            comp.setLanguage(Language.CPP);
        } else if (language.getNodeValue().toUpperCase().equals("JAVA")) {
            comp.setLanguage(Language.JAVA);
        } else {
            if (!language.getNodeValue().toUpperCase().equals("OTHER")) throw new TypeImportException(Messages.CompilableElementImporter_ERROR_UnsupportedLanguage);
            comp.setLanguage(Language.OTHER);
        }
        Node vendor = map.getNamedItem("Vendor");
        if (vendor == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_VendorNotSet);
        }
        comp.setVendor(vendor.getNodeValue());
        Node product = map.getNamedItem("Product");
        if (product == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_ProductNotSet);
        }
        comp.setProduct(product.getNodeValue());
        Node version = map.getNamedItem("Version");
        if (version == null) {
            throw new TypeImportException(Messages.CompilableElementImporter_ERROR_VersionNotSet);
        }
        comp.setVersion(version.getNodeValue());
        compilerInfo.getCompiler().add((Object)comp);
    }
}

