/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADPImporter {
    public static HashMap<String, VarDeclaration> variables = new HashMap();
    public static HashMap<String, VarDeclaration> adapterVariables = new HashMap();
    public static HashMap<String, Event> events = new HashMap();
    public static HashMap<String, Event> adapterEvents = new HashMap();

    public static AdapterType importAdapterType(IFile iFile) {
        if (iFile.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            try {
                dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(iFile.getContents());
                Element rootNode = document.getDocumentElement();
                AdapterType type = LibraryElementFactory.eINSTANCE.createAdapterType();
                return ADPImporter.parseAdapterType(type, rootNode);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        return null;
    }

    private static AdapterType parseAdapterType(AdapterType type, Node rootNode) throws TypeImportException, ParseException {
        variables.clear();
        adapterVariables.clear();
        events.clear();
        adapterEvents.clear();
        AdapterFBType adapterFBType = LibraryElementFactory.eINSTANCE.createAdapterFBType();
        type.setAdapterFBType(adapterFBType);
        adapterFBType.setAdapterType(type);
        if (rootNode.getNodeName().equals("AdapterType")) {
            Node comment;
            NamedNodeMap map = rootNode.getAttributes();
            Node name = map.getNamedItem("Name");
            if (name != null) {
                adapterFBType.setName(name.getNodeValue());
            }
            if ((comment = map.getNamedItem("Comment")) != null) {
                adapterFBType.setComment(type.getComment());
            }
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("Identification")) {
                    adapterFBType.setIdentification(CommonElementImporter.parseIdentification(adapterFBType, n));
                }
                if (n.getNodeName().equals("VersionInfo")) {
                    adapterFBType.getVersionInfo().add((Object)CommonElementImporter.parseVersionInfo(adapterFBType, n));
                }
                n.getNodeName().equals("CompilerInfo");
                if (n.getNodeName().equals("InterfaceList")) {
                    InterfaceList interfaceList_socket = LibraryElementFactory.eINSTANCE.createInterfaceList();
                    adapterFBType.setInterfaceList(interfaceList_socket);
                    ADPImporter.parseInterfaceList(interfaceList_socket, n, adapterEvents, adapterVariables, false);
                }
                if (n.getNodeName().equals("Service")) {
                    Service service = LibraryElementFactory.eINSTANCE.createService();
                    adapterFBType.setService(service);
                    new FBTImporter().parseService(adapterFBType, n);
                }
                ++i;
            }
            return type;
        }
        throw new ParseException("Parse Adaptertype Exception", 0);
    }

    private static void parseEventOutputs(List<Event> eventOutputs, Node node, HashMap<String, Event> events) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("Event")) {
                Event e = ImportUtils.parseEvent(n);
                events.put(e.getName(), e);
                e.setIsInput(false);
                eventOutputs.add(e);
            }
            ++i;
        }
    }

    private static void parseEventInputs(List<Event> eventInputs, Node node, HashMap<String, Event> events) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("Event")) {
                Event e = ImportUtils.parseEvent(n);
                e.setIsInput(true);
                events.put(e.getName(), e);
                eventInputs.add(e);
            }
            ++i;
        }
    }

    private static void parseInterfaceList(InterfaceList interfaceList, Node node, HashMap<String, Event> events, HashMap<String, VarDeclaration> variables, boolean invertInterface) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            List<VarDeclaration> vars;
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("EventInputs")) {
                if (invertInterface) {
                    ADPImporter.parseEventOutputs(interfaceList.getEventOutputs(), n, events);
                } else {
                    ADPImporter.parseEventInputs(interfaceList.getEventInputs(), n, events);
                }
            }
            if (n.getNodeName().equals("EventOutputs")) {
                if (invertInterface) {
                    ADPImporter.parseEventInputs(interfaceList.getEventInputs(), n, events);
                } else {
                    ADPImporter.parseEventOutputs(interfaceList.getEventOutputs(), n, events);
                }
            }
            if (n.getNodeName().equals("InputVars")) {
                vars = ImportUtils.parseInputVariables(n);
                for (VarDeclaration v : vars) {
                    if (invertInterface) {
                        v.setIsInput(false);
                        interfaceList.getOutputVars().add((Object)v);
                    } else {
                        v.setIsInput(true);
                        interfaceList.getInputVars().add((Object)v);
                    }
                    variables.put(v.getName(), v);
                }
            }
            if (n.getNodeName().equals("OutputVars")) {
                vars = ImportUtils.parseOutputVariables(n);
                for (VarDeclaration v : vars) {
                    if (invertInterface) {
                        v.setIsInput(true);
                        interfaceList.getInputVars().add((Object)v);
                    } else {
                        v.setIsInput(false);
                        interfaceList.getOutputVars().add((Object)v);
                    }
                    variables.put(v.getName(), v);
                }
            }
            ++i;
        }
        new FBTImporter().parseWithConstructs(childNodes, events, events, variables);
    }
}

