/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.deployment.AbstractDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.Activator;
import org.eclipse.fordiac.ide.deployment.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.IDeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.Messages;
import org.eclipse.fordiac.ide.deployment.ResourceDeploymentData;
import org.eclipse.fordiac.ide.deployment.exceptions.CreateConnectionException;
import org.eclipse.fordiac.ide.deployment.exceptions.CreateFBInstanceException;
import org.eclipse.fordiac.ide.deployment.exceptions.CreateResourceInstanceException;
import org.eclipse.fordiac.ide.deployment.exceptions.DisconnectException;
import org.eclipse.fordiac.ide.deployment.exceptions.InvalidMgmtID;
import org.eclipse.fordiac.ide.deployment.exceptions.StartException;
import org.eclipse.fordiac.ide.deployment.exceptions.WriteFBParameterException;
import org.eclipse.fordiac.ide.deployment.exceptions.WriteResourceParameterException;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeploymentCoordinator
implements IDeploymentListener {
    private static DeploymentCoordinator instance;
    private List<IDeploymentExecutor> deploymentExecutors = null;
    private List<AbstractDeviceManagementCommunicationHandler> deviceMangementCommunicationHandlers = null;
    private final Map<Device, List<VarDeclaration>> deployedDeviceProperties = new HashMap<Device, List<VarDeclaration>>();
    private final List<IDeploymentListener> listeners = new ArrayList<IDeploymentListener>();

    public void addDeviceProperty(Device dev, VarDeclaration property) {
        if (this.deployedDeviceProperties.containsKey(dev)) {
            List<VarDeclaration> temp = this.deployedDeviceProperties.get(dev);
            if (!temp.contains(property)) {
                temp.add(property);
            }
        } else {
            ArrayList<VarDeclaration> temp = new ArrayList<VarDeclaration>();
            temp.add(property);
            this.deployedDeviceProperties.put(dev, temp);
        }
    }

    public void setDeviceProperties(Device dev, List<VarDeclaration> properties) {
        this.deployedDeviceProperties.put(dev, properties);
    }

    public void removeDeviceProperty(Device dev, VarDeclaration property) {
        List<VarDeclaration> temp;
        if (this.deployedDeviceProperties.containsKey(dev) && (temp = this.deployedDeviceProperties.get(dev)).contains(property)) {
            temp.remove(property);
        }
    }

    public List<VarDeclaration> getSelectedDeviceProperties(Device dev) {
        return this.deployedDeviceProperties.get(dev);
    }

    private DeploymentCoordinator() {
    }

    public static DeploymentCoordinator getInstance() {
        if (instance == null) {
            instance = new DeploymentCoordinator();
        }
        return instance;
    }

    private String getMGR_ID(Resource resource) {
        return DeploymentCoordinator.getMGR_ID(resource.getDevice());
    }

    public static String getMGR_ID(Device dev) {
        for (VarDeclaration varDecl : dev.getVarDeclarations()) {
            String val;
            if (!varDecl.getName().equalsIgnoreCase("MGR_ID") || (val = DeploymentHelper.getVariableValue(varDecl, dev.getAutomationSystem())) == null) continue;
            return val;
        }
        return "";
    }

    private int countWorkCreatingFBs(FBNetwork fbNetwork) {
        int work = 0;
        for (FBNetworkElement element : fbNetwork.getNetworkElements()) {
            if (element instanceof SubApp) {
                work += this.countWorkCreatingFBs(((SubApp)element).getSubAppNetwork());
                continue;
            }
            if (!(element instanceof FB)) continue;
            ++work;
            FB fb = (FB)element;
            InterfaceList interfaceList = fb.getInterface();
            if (interfaceList == null) continue;
            for (VarDeclaration varDecl : interfaceList.getInputVars()) {
                Value value;
                if (varDecl.getInputConnections().size() != 0 || (value = varDecl.getValue()) == null || value.getValue() == null) continue;
                ++work;
            }
        }
        return work;
    }

    public static void printUnsupportedDeviceProfileMessageBox(final Device device, final Resource res) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
                String resName = "";
                if (res != null) {
                    resName = res.getName();
                }
                if (device.getProfile() != null && !device.getProfile().equals("")) {
                    messageBox.setMessage(MessageFormat.format(Messages.DeploymentCoordinator_MESSAGE_DefinedProfileNotSupported, device.getProfile() != null ? device.getProfile() : "", device.getName(), resName));
                } else {
                    messageBox.setMessage(MessageFormat.format(Messages.DeploymentCoordinator_MESSAGE_ProfileNotSet, device.getName(), resName));
                }
                messageBox.open();
            }
        });
    }

    public void performDeployment(Object[] selection, AbstractDeviceManagementCommunicationHandler overrideDevMgmCommHandler) {
        ArrayList<Device> devices = new ArrayList<Device>();
        ArrayList<ResourceDeploymentData> resDepData = new ArrayList<ResourceDeploymentData>();
        int i = 0;
        while (i < selection.length) {
            List<VarDeclaration> parameters;
            Object object = selection[i];
            if (object instanceof Resource) {
                resDepData.add(new ResourceDeploymentData((Resource)object));
            } else if (object instanceof Device && (parameters = this.getSelectedDeviceProperties((Device)object)) != null && parameters.size() > 0) {
                devices.add((Device)object);
            }
            ++i;
        }
        DownloadRunnable download = new DownloadRunnable(devices, resDepData, overrideDevMgmCommHandler);
        Shell shell = Display.getDefault().getActiveShell();
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)download);
        }
        catch (InvocationTargetException ex) {
            MessageDialog.openError((Shell)shell, (String)"Error", (String)ex.getMessage());
        }
        catch (InterruptedException ex) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.DeploymentCoordinator_LABEL_DownloadAborted, (String)ex.getMessage());
        }
    }

    public void performDeployment(Object[] selection) {
        this.performDeployment(selection, null);
    }

    public IDeploymentExecutor getDeploymentExecutor(Device device, AbstractDeviceManagementCommunicationHandler overrideComHandler) {
        if (this.deploymentExecutors == null) {
            this.deploymentExecutors = DeploymentCoordinator.loadDeploymentExecutors();
        }
        for (IDeploymentExecutor idepExec : this.deploymentExecutors) {
            if (!idepExec.supports(device.getProfile())) continue;
            idepExec.setDeviceManagementCommunicationHandler(overrideComHandler != null ? overrideComHandler : this.getDevMgmCommunicationHandler(device));
            return idepExec.getDevMgmComHandler() != null ? idepExec : null;
        }
        return null;
    }

    public IDeploymentExecutor getDeploymentExecutor(Device device) {
        return this.getDeploymentExecutor(device, null);
    }

    public static List<IDeploymentExecutor> loadDeploymentExecutors() {
        IConfigurationElement[] elems;
        ArrayList<IDeploymentExecutor> deploymentExecutors = new ArrayList<IDeploymentExecutor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.deployment", "downloadexecutor");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IDeploymentExecutor) {
                    deploymentExecutors.add((IDeploymentExecutor)object);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError(Messages.DeploymentCoordinator_ERROR_Message, (Exception)((Object)corex));
            }
            ++n2;
        }
        return deploymentExecutors;
    }

    private AbstractDeviceManagementCommunicationHandler getDevMgmCommunicationHandler(Device device) {
        if (this.deviceMangementCommunicationHandlers == null) {
            this.loadDeviceManagementCommunicationHandlers();
        }
        if (this.deviceMangementCommunicationHandlers.size() > 0) {
            return this.deviceMangementCommunicationHandlers.get(0);
        }
        return null;
    }

    private void loadDeviceManagementCommunicationHandlers() {
        IConfigurationElement[] elems;
        this.deviceMangementCommunicationHandlers = new ArrayList<AbstractDeviceManagementCommunicationHandler>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.deployment", "devicemanagementcommunicationhandler");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof AbstractDeviceManagementCommunicationHandler) {
                    this.deviceMangementCommunicationHandlers.add((AbstractDeviceManagementCommunicationHandler)object);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError(Messages.DeploymentCoordinator_ERROR_Message, (Exception)((Object)corex));
            }
            ++n2;
        }
    }

    @Override
    public void responseReceived(String response, String source) {
        this.listeners.forEach(l -> l.responseReceived(response, source));
    }

    @Override
    public void postCommandSent(String command, String destination) {
        this.listeners.forEach(l -> l.postCommandSent(command, destination));
    }

    @Override
    public void postCommandSent(String info, String destination, String command) {
        this.listeners.forEach(l -> l.postCommandSent(info, destination, command));
    }

    @Override
    public void postCommandSent(String message) {
        this.listeners.forEach(l -> l.postCommandSent(message));
    }

    @Override
    public void finished() {
        this.listeners.forEach(l -> l.finished());
    }

    public void addDeploymentListener(IDeploymentListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeDeploymentListener(IDeploymentListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void enableOutput(AbstractDeviceManagementCommunicationHandler handler) {
        handler.addDeploymentListener(this);
    }

    public void flush() {
        this.finished();
    }

    public void disableOutput(AbstractDeviceManagementCommunicationHandler handler) {
        handler.removeDeploymentListener(this);
    }

    class DownloadRunnable
    implements IRunnableWithProgress {
        private final List<Device> devices;
        private final List<ResourceDeploymentData> resources;
        private AbstractDeviceManagementCommunicationHandler overrideDevMgmCommHandler;

        public DownloadRunnable(List<Device> devices, List<ResourceDeploymentData> resources, AbstractDeviceManagementCommunicationHandler overrideDevMgmCommHandler) {
            this.devices = devices;
            this.resources = resources;
            this.overrideDevMgmCommHandler = overrideDevMgmCommHandler;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.DeploymentCoordinator_LABEL_PerformingDownload, this.calculateWorkAmount());
            for (final ResourceDeploymentData resDepData : this.resources) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.DeploymentCoordinator_LABEL_DownloadAborted);
                }
                IDeploymentExecutor executor = DeploymentCoordinator.this.getDeploymentExecutor(resDepData.res.getDevice(), this.overrideDevMgmCommHandler);
                if (executor != null) {
                    executor.getDevMgmComHandler().addDeploymentListener(DeploymentCoordinator.getInstance());
                    executor.getDevMgmComHandler().resetTypes();
                    try {
                        this.deployResource(monitor, resDepData, executor);
                    }
                    catch (Exception e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = Display.getDefault().getActiveShell();
                                MessageDialog.openError((Shell)shell, (String)"Major Download Error", (String)("Resource: " + resDepData.res.getDevice().getName() + "." + resDepData.res.getName() + "\n" + "MGR_ID: " + DeploymentCoordinator.this.getMGR_ID(resDepData.res) + "\n" + "Problem: " + e.getMessage()));
                            }
                        });
                    }
                    executor.getDevMgmComHandler().removeDeploymentListener(DeploymentCoordinator.getInstance());
                    continue;
                }
                DeploymentCoordinator.printUnsupportedDeviceProfileMessageBox(resDepData.res.getDevice(), resDepData.res);
            }
            for (Device device : this.devices) {
                this.configureDevice(monitor, device);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException(Messages.DeploymentCoordinator_LABEL_DownloadAborted);
            }
            DeploymentCoordinator.this.finished();
            monitor.done();
        }

        private int calculateWorkAmount() {
            int retVal = this.devices.size() + this.resources.size();
            for (ResourceDeploymentData resDepData : this.resources) {
                retVal += this.countResourceParams(resDepData.res);
                retVal += resDepData.fbs.size() + resDepData.connections.size() + resDepData.params.size();
            }
            return retVal;
        }

        private int countResourceParams(Resource res) {
            int work = 0;
            for (VarDeclaration varDecl : res.getVarDeclarations()) {
                if (varDecl.getValue() == null || varDecl.getValue().getValue() == null || !varDecl.getValue().getValue().equals("")) continue;
                ++work;
            }
            return work;
        }

        protected void deployResource(IProgressMonitor monitor, ResourceDeploymentData resDepData, IDeploymentExecutor executor) throws InvalidMgmtID, UnknownHostException, IOException, CreateResourceInstanceException, WriteResourceParameterException, CreateFBInstanceException, WriteFBParameterException, CreateConnectionException, StartException, DisconnectException {
            Resource res = resDepData.res;
            if (!res.isDeviceTypeResource()) {
                try {
                    executor.getDevMgmComHandler().connect(DeploymentCoordinator.this.getMGR_ID(res));
                    executor.createResource(res);
                    monitor.worked(1);
                    for (VarDeclaration varDecl : res.getVarDeclarations()) {
                        String val = DeploymentHelper.getVariableValue(varDecl, res.getAutomationSystem());
                        if (val == null) continue;
                        executor.writeResourceParameter(res, varDecl.getName(), val);
                        monitor.worked(1);
                    }
                    this.createFBInstance(resDepData, executor, monitor);
                    this.deployParamters(resDepData, executor, monitor);
                    this.deployConnections(resDepData, executor, monitor);
                    if (!this.devices.contains(res.getDevice())) {
                        executor.startResource(res);
                    }
                }
                finally {
                    executor.getDevMgmComHandler().disconnect();
                }
            }
        }

        private void configureDevice(IProgressMonitor monitor, Device device) {
            IDeploymentExecutor executor = DeploymentCoordinator.this.getDeploymentExecutor(device, this.overrideDevMgmCommHandler);
            List<VarDeclaration> parameters = DeploymentCoordinator.this.getSelectedDeviceProperties(device);
            if (executor != null && parameters != null && parameters.size() > 0) {
                try {
                    try {
                        executor.getDevMgmComHandler().addDeploymentListener(DeploymentCoordinator.getInstance());
                        String mgrid = DeploymentCoordinator.getMGR_ID(device);
                        executor.getDevMgmComHandler().connect(mgrid);
                        for (VarDeclaration varDeclaration : parameters) {
                            String value = DeploymentHelper.getVariableValue(varDeclaration, device.getAutomationSystem());
                            if (value == null) continue;
                            executor.writeDeviceParameter(device, varDeclaration.getName(), value);
                        }
                        executor.startDevice(device);
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                        try {
                            executor.getDevMgmComHandler().disconnect();
                        }
                        catch (DisconnectException e2) {
                            Activator.getDefault().logError(e2.getMessage(), e2);
                        }
                        executor.getDevMgmComHandler().removeDeploymentListener(DeploymentCoordinator.getInstance());
                    }
                }
                finally {
                    try {
                        executor.getDevMgmComHandler().disconnect();
                    }
                    catch (DisconnectException e) {
                        Activator.getDefault().logError(e.getMessage(), e);
                    }
                    executor.getDevMgmComHandler().removeDeploymentListener(DeploymentCoordinator.getInstance());
                }
            }
        }

        private void deployParamters(ResourceDeploymentData resDepData, IDeploymentExecutor executor, IProgressMonitor monitor) throws WriteFBParameterException {
            for (ResourceDeploymentData.ParameterData param : resDepData.params) {
                executor.writeFBParameter(resDepData.res, param.value, new FBDeploymentData(param.prefix, (FB)param.var.getFBNetworkElement()), param.var);
                monitor.worked(1);
            }
        }

        private void deployConnections(ResourceDeploymentData resDepData, IDeploymentExecutor executor, IProgressMonitor monitor) throws CreateConnectionException {
            for (ConnectionDeploymentData con : resDepData.connections) {
                executor.createConnection(resDepData.res, con);
                monitor.worked(1);
                if (monitor.isCanceled()) break;
            }
        }

        private void createFBInstance(ResourceDeploymentData resDepData, IDeploymentExecutor executor, IProgressMonitor monitor) throws CreateFBInstanceException, WriteFBParameterException {
            Resource res = resDepData.res;
            for (FBDeploymentData fb : resDepData.fbs) {
                if (fb.fb.isResourceTypeFB()) continue;
                executor.createFBInstance(fb, res);
                monitor.worked(1);
                InterfaceList interfaceList = fb.fb.getInterface();
                if (interfaceList == null) continue;
                for (VarDeclaration varDecl : interfaceList.getInputVars()) {
                    String val = DeploymentHelper.getVariableValue(varDecl, res.getAutomationSystem());
                    if (val == null) continue;
                    executor.writeFBParameter(res, val, fb, varDecl);
                    monitor.worked(1);
                }
            }
        }
    }
}

