/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.fordiac.ide.deployment.AbstractDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.Activator;
import org.eclipse.fordiac.ide.deployment.exceptions.DisconnectException;
import org.eclipse.fordiac.ide.deployment.exceptions.InvalidMgmtID;
import org.eclipse.fordiac.ide.deployment.iec61499.Messages;
import org.eclipse.fordiac.ide.deployment.iec61499.QueryResponseHandler;
import org.eclipse.fordiac.ide.deployment.iec61499.preferences.HoloblocDeploymentPreferences;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class EthernetDeviceManagementCommunicationHandler
extends AbstractDeviceManagementCommunicationHandler {
    private static final int ASN1_TAG_IECSTRING = 80;
    private MgrInformation mgrInfo;
    private Socket socket;
    private DataOutputStream outputStream;
    private DataInputStream inputStream;

    public void connect(String address) throws InvalidMgmtID, UnknownHostException, IOException {
        this.mgrInfo = this.getValidMgrInformation(address);
        this.socket = new Socket();
        int timeout = HoloblocDeploymentPreferences.getConnectionTimeout();
        InetSocketAddress sockaddr = new InetSocketAddress(this.mgrInfo.iP, (int)this.mgrInfo.port);
        this.socket.connect(sockaddr, timeout);
        this.socket.setSoTimeout(timeout);
        this.outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
    }

    public void disconnect() throws DisconnectException {
        try {
            this.outputStream.close();
            this.inputStream.close();
            this.socket.close();
            Thread.sleep(50L);
        }
        catch (IOException iOException) {
            throw new DisconnectException(MessageFormat.format(Messages.DeploymentExecutor_DisconnectFailed, new Object[0]));
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)e);
        }
    }

    public void sendREQ(String destination, String request) throws IOException {
        if (this.outputStream != null && this.inputStream != null) {
            this.outputStream.writeByte(80);
            this.outputStream.writeShort(destination.length());
            this.outputStream.writeBytes(destination);
            this.outputStream.writeByte(80);
            this.outputStream.writeShort(request.length());
            this.outputStream.writeBytes(request);
            this.outputStream.flush();
            this.postCommandSent(this.getInfo(destination), destination, request);
            this.handleResponse(destination);
        }
    }

    private String handleResponse(String destination) throws IOException {
        this.inputStream.readByte();
        int size = this.inputStream.readShort();
        StringBuilder response = new StringBuilder(size);
        int i = 0;
        while (i < size) {
            response.append((char)this.inputStream.readByte());
            ++i;
        }
        String retVal = response.toString();
        if (response.length() != 0) {
            this.responseReceived(retVal, this.getInfo(destination));
        }
        return retVal;
    }

    private String getInfo(String destination) {
        String info = this.mgrInfo.toString();
        if (!destination.equals("")) {
            info = String.valueOf(info) + ": " + destination;
        }
        return info;
    }

    public String sendREQandRESP(String destination, String request) throws IOException {
        String response = "";
        if (this.outputStream != null && this.inputStream != null) {
            this.outputStream.writeByte(80);
            this.outputStream.writeShort(destination.length());
            this.outputStream.writeBytes(destination);
            this.outputStream.writeByte(80);
            this.outputStream.writeShort(request.length());
            this.outputStream.writeBytes(request);
            this.outputStream.flush();
            this.postCommandSent(this.getInfo(destination), destination, request);
            response = this.handleResponse(destination);
        }
        return response;
    }

    private MgrInformation getValidMgrInformation(String mgrID) throws InvalidMgmtID {
        if (mgrID != null) {
            String id = mgrID;
            if (id.startsWith("\"")) {
                id = id.substring(1, id.length());
            }
            if (id.endsWith("\"")) {
                id = id.substring(0, id.length() - 1);
            }
            String[] splitID = id.split(":");
            MgrInformation mgrInfo = new MgrInformation();
            if (splitID.length == 2) {
                Integer port;
                try {
                    InetAddress adress = InetAddress.getByName(splitID[0]);
                    mgrInfo.iP = adress.getHostAddress();
                    port = Integer.parseInt(splitID[1]);
                }
                catch (NumberFormatException | UnknownHostException exception) {
                    throw new InvalidMgmtID(mgrID);
                }
                if (1023 < port && port < 65536) {
                    mgrInfo.port = port;
                    return mgrInfo;
                }
            }
        }
        throw new InvalidMgmtID(mgrID);
    }

    public void sendQUERY(String destination, String request) throws IOException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxParserFactory.newSAXParser();
            QueryResponseHandler handler = new QueryResponseHandler();
            String response = this.sendREQandRESP(destination, request);
            saxParser.parse(new InputSource(new StringReader(response)), (DefaultHandler)handler);
            if (request.contains("FBType")) {
                this.getFBTypes(this.getInfo(destination), handler);
            } else if (request.contains("AdapterType")) {
                this.getAdapterTypes(this.getInfo(destination), handler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getFBTypes(String info, QueryResponseHandler handler) {
        if (this.fbTypes == null) {
            this.fbTypes = new HashSet();
        }
        this.fbTypes = handler.getQueryResult();
    }

    private void getAdapterTypes(String info, QueryResponseHandler handler) {
        if (this.adapterTypes == null) {
            this.adapterTypes = new HashSet();
        }
        this.adapterTypes = handler.getQueryResult();
    }

    private class MgrInformation {
        public String iP;
        public Integer port;

        private MgrInformation() {
        }

        public String toString() {
            return String.valueOf(this.iP) + ":" + this.port;
        }
    }
}

