/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.ApplicationPlugin;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.wizards.SaveAsSubappWizardPage;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SaveAsSubappWizard
extends Wizard {
    final SubApp subApp;
    private SaveAsSubappWizardPage newFilePage;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public SaveAsSubappWizard(SubApp subApp) {
        this.setWindowTitle(Messages.SaveAsSubApplicationTypeAction_WizardTitle);
        this.subApp = subApp;
    }

    public void addPages() {
        IProject project = this.subApp.getSubAppNetwork().getAutomationSystem().getProject();
        StructuredSelection selection = new StructuredSelection((Object)project);
        this.newFilePage = new SaveAsSubappWizardPage(Messages.SaveAsSubApplicationTypeAction_WizardPageName, (IStructuredSelection)selection);
        this.newFilePage.setFileName(this.subApp.getName());
        this.addPage((IWizardPage)this.newFilePage);
    }

    public boolean performFinish() {
        boolean perform = true;
        IFile targetFile = this.getTargetTypeFile();
        if (targetFile.exists()) {
            perform = this.askOverwrite();
        }
        if (perform) {
            if (this.createSubAppTemplateCopy()) {
                PaletteEntry entry = this.getPalletEntry();
                LibraryElement type = entry.getType();
                type.setName(TypeLibrary.getTypeNameFromFile((IFile)entry.getFile()));
                if (type.getVersionInfo().size() != 0) {
                    VersionInfo versionInfo = (VersionInfo)type.getVersionInfo().get(0);
                    versionInfo.setDate(this.format.format(new Date(System.currentTimeMillis())));
                }
                this.performTypeSetup((SubAppType)type);
                CommonElementExporter.saveType((PaletteEntry)entry);
                if (this.newFilePage.getOpenType()) {
                    this.openTypeEditor(entry);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean askOverwrite() {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideTitle, (String)Messages.SaveAsSubApplicationTypeAction_WizardOverrideMessage);
    }

    private boolean createSubAppTemplateCopy() {
        String templateFolderPath = Platform.getInstallLocation().getURL().getFile();
        File templateFolder = new File(String.valueOf(templateFolderPath) + File.separatorChar + "template");
        File[] fileArray = templateFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName().toUpperCase();
            if (fileName.endsWith("SUB")) {
                IFile targetTypeFile = this.getTargetTypeFile();
                try {
                    ImportUtils.copyFile((File)file, (IFile)targetTypeFile);
                    return true;
                }
                catch (IOException | CoreException e) {
                    ApplicationPlugin.getDefault().logError(e.getMessage(), (Exception)e);
                }
            }
            ++n2;
        }
        return false;
    }

    private IFile getTargetTypeFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.newFilePage.getContainerFullPath() + "/" + this.newFilePage.getFileName() + ".SUB"));
    }

    private PaletteEntry getPalletEntry() {
        IFile targetTypeFile;
        Palette palette = this.subApp.getSubAppNetwork().getAutomationSystem().getPalette();
        PaletteEntry entry = TypeLibrary.getPaletteEntry((Palette)palette, (IFile)(targetTypeFile = this.getTargetTypeFile()));
        if (entry == null) {
            TypeLibrary.refreshPalette((Palette)palette);
            entry = TypeLibrary.getPaletteEntry((Palette)palette, (IFile)targetTypeFile);
        }
        return entry;
    }

    private void openTypeEditor(PaletteEntry entry) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
        try {
            page.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), desc.getId());
        }
        catch (PartInitException e) {
            ApplicationPlugin.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void performTypeSetup(SubAppType type) {
        this.performInterfaceSetup(type);
        this.performSubappNetworkSetup(type);
    }

    private void performInterfaceSetup(SubAppType type) {
        InterfaceList interfaceList = LibraryElementFactory.eINSTANCE.createInterfaceList();
        type.setInterfaceList(interfaceList);
    }

    private IInterfaceElement createEventElement(InterfaceList interfaceList, Event element) {
        Event e = LibraryElementFactory.eINSTANCE.createEvent();
        if (element.isIsInput()) {
            interfaceList.getEventOutputs().add((Object)e);
        } else {
            interfaceList.getEventInputs().add((Object)e);
        }
        return e;
    }

    private IInterfaceElement createAdapterElement(InterfaceList interfaceList, AdapterDeclaration element) {
        AdapterDeclaration a = LibraryElementFactory.eINSTANCE.createAdapterDeclaration();
        a.setType(element.getType());
        a.setTypeName(element.getTypeName());
        if (element.isIsInput()) {
            interfaceList.getPlugs().add((Object)a);
        } else {
            interfaceList.getSockets().add((Object)a);
        }
        return a;
    }

    private IInterfaceElement createVarElement(InterfaceList interfaceList, VarDeclaration element) {
        VarDeclaration v = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        v.setType(element.getType());
        v.setTypeName(element.getTypeName());
        v.setArraySize(element.getArraySize());
        if (element.isIsInput()) {
            interfaceList.getOutputVars().add((Object)v);
        } else {
            interfaceList.getInputVars().add((Object)v);
        }
        return v;
    }

    private void performSubappNetworkSetup(SubAppType type) {
        FBNetwork srcNetwork = this.subApp.getSubAppNetwork();
        FBNetwork dstNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        type.setFBNetwork(dstNetwork);
        dstNetwork.getNetworkElements().addAll(EcoreUtil.copyAll((Collection)srcNetwork.getNetworkElements()));
        this.copyEventConnections(type);
        this.copyDataConnections(type);
        this.copyInterfaceConnections(type);
    }

    private void copyEventConnections(SubAppType type) {
        FBNetwork srcNetwork = this.subApp.getSubAppNetwork();
        for (EventConnection eCon : srcNetwork.getEventConnections()) {
            Event src = this.getEventConTarget(eCon.getEventSource(), type);
            Event dst = this.getEventConTarget(eCon.getEventDestination(), type);
            this.createEventConnection(type.getFBNetwork(), src, dst, eCon);
        }
    }

    private void copyDataConnections(SubAppType type) {
        FBNetwork srcNetwork = this.subApp.getSubAppNetwork();
        for (DataConnection dCon : srcNetwork.getDataConnections()) {
            VarDeclaration src = this.getDataConTarget(dCon.getDataSource(), type);
            VarDeclaration dst = this.getDataConTarget(dCon.getDataDestination(), type);
            this.createDataConnection(type.getFBNetwork(), src, dst, dCon);
        }
    }

    private void copyInterfaceConnections(SubAppType type) {
        type.getFBNetwork();
    }

    private void createEventConnection(FBNetwork dstNetwork, Event src, Event dst, EventConnection refEventCon) {
        if (src != null && dst != null) {
            EventConnection eventCon = LibraryElementFactory.eINSTANCE.createEventConnection();
            eventCon.setResTypeConnection(true);
            eventCon.setSource((IInterfaceElement)src);
            eventCon.setDestination((IInterfaceElement)dst);
            if (refEventCon != null) {
                this.performGeneralConnectionConfiguration((Connection)eventCon, (Connection)refEventCon);
            }
            if (!this.connectionExists((EList<? extends Connection>)dstNetwork.getEventConnections(), (Connection)eventCon)) {
                dstNetwork.getEventConnections().add((Object)eventCon);
            }
        }
    }

    private void createDataConnection(FBNetwork dstNetwork, VarDeclaration src, VarDeclaration dst, DataConnection refDataCon) {
        if (src != null && dst != null) {
            DataConnection dataCon = LibraryElementFactory.eINSTANCE.createDataConnection();
            dataCon.setResTypeConnection(true);
            dataCon.setSource((IInterfaceElement)src);
            dataCon.setDestination((IInterfaceElement)dst);
            if (refDataCon != null) {
                this.performGeneralConnectionConfiguration((Connection)dataCon, (Connection)refDataCon);
            }
            if (!this.connectionExists((EList<? extends Connection>)dstNetwork.getDataConnections(), (Connection)dataCon)) {
                dstNetwork.getDataConnections().add((Object)dataCon);
            }
        }
    }

    private boolean connectionExists(EList<? extends Connection> connectionList, Connection newConnection) {
        for (Connection connection : connectionList) {
            if (!connection.getSource().equals(newConnection.getSource()) || !connection.getDestination().equals(newConnection.getDestination())) continue;
            return true;
        }
        return false;
    }

    private void performGeneralConnectionConfiguration(Connection con, Connection refCon) {
        con.setComment(refCon.getComment());
        con.setDx1(refCon.getDx1());
        con.setDx2(refCon.getDx2());
        con.setDy(refCon.getDy());
    }

    private Event getEventConTarget(Event element, SubAppType type) {
        InterfaceList targetElement = this.getConTargetElement((IInterfaceElement)element, type);
        if (targetElement != null) {
            return targetElement.getEvent(element.getName());
        }
        return null;
    }

    private VarDeclaration getDataConTarget(VarDeclaration element, SubAppType type) {
        InterfaceList targetElement = this.getConTargetElement((IInterfaceElement)element, type);
        if (targetElement != null) {
            return targetElement.getVariable(element.getName());
        }
        return null;
    }

    private InterfaceList getConTargetElement(IInterfaceElement iInterfaceElement, SubAppType type) {
        FBNetworkElement target = iInterfaceElement.getFBNetworkElement();
        for (FBNetworkElement element : type.getFBNetwork().getNetworkElements()) {
            if (!element.getName().equals(target.getName())) continue;
            return element.getInterface();
        }
        return null;
    }
}

