/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.util.ElementSelector;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class FlattenSubAppCommand
extends Command {
    final SubApp subapp;
    final FBNetwork parent;
    List<FBNetworkElement> elements = new ArrayList<FBNetworkElement>();
    List<EventConnection> transferEventConnections = new ArrayList<EventConnection>();
    List<DataConnection> transferDataConnections = new ArrayList<DataConnection>();
    List<AdapterConnection> transferAdapterConnections = new ArrayList<AdapterConnection>();
    CompoundCommand deleteCommands = new CompoundCommand();
    CompoundCommand createCommands = new CompoundCommand();
    CompoundCommand mappCommands = new CompoundCommand();

    public FlattenSubAppCommand(SubApp subapp) {
        super(Messages.FlattenSubAppCommand_LABEL_FlattenSubAppCommand);
        this.subapp = subapp;
        this.parent = subapp.getFbNetwork();
    }

    public void execute() {
        this.elements.addAll((Collection<FBNetworkElement>)this.subapp.getSubAppNetwork().getNetworkElements());
        this.adjustFBNElementPosition(this.subapp.getX(), this.subapp.getY());
        this.checkConnections();
        this.createMappCommands();
        this.deleteCommands.add((Command)new DeleteFBNetworkElementCommand((FBNetworkElement)this.subapp));
        this.deleteCommands.execute();
        this.subapp.getSubAppNetwork().getNetworkElements().removeAll(this.elements);
        this.parent.getNetworkElements().addAll(this.elements);
        this.subapp.getSubAppNetwork().getEventConnections().removeAll(this.transferEventConnections);
        this.parent.getEventConnections().addAll(this.transferEventConnections);
        this.subapp.getSubAppNetwork().getDataConnections().removeAll(this.transferDataConnections);
        this.parent.getDataConnections().addAll(this.transferDataConnections);
        this.subapp.getSubAppNetwork().getAdapterConnections().removeAll(this.transferAdapterConnections);
        this.parent.getAdapterConnections().addAll(this.transferAdapterConnections);
        this.createCommands.execute();
        this.mappCommands.execute();
        ElementSelector selector = new ElementSelector();
        selector.selectViewObjects(this.elements);
    }

    public void redo() {
        this.deleteCommands.redo();
        this.subapp.getSubAppNetwork().getNetworkElements().removeAll(this.elements);
        this.parent.getNetworkElements().addAll(this.elements);
        this.adjustFBNElementPosition(this.subapp.getX(), this.subapp.getY());
        this.subapp.getSubAppNetwork().getEventConnections().removeAll(this.transferEventConnections);
        this.parent.getEventConnections().addAll(this.transferEventConnections);
        this.subapp.getSubAppNetwork().getDataConnections().removeAll(this.transferDataConnections);
        this.parent.getDataConnections().addAll(this.transferDataConnections);
        this.subapp.getSubAppNetwork().getAdapterConnections().removeAll(this.transferAdapterConnections);
        this.parent.getAdapterConnections().addAll(this.transferAdapterConnections);
        this.createCommands.redo();
        this.mappCommands.redo();
    }

    public void undo() {
        this.mappCommands.undo();
        this.createCommands.undo();
        this.parent.getNetworkElements().removeAll(this.elements);
        this.subapp.getSubAppNetwork().getNetworkElements().addAll(this.elements);
        this.adjustFBNElementPosition(-this.subapp.getX(), -this.subapp.getY());
        this.parent.getEventConnections().removeAll(this.transferEventConnections);
        this.subapp.getSubAppNetwork().getEventConnections().addAll(this.transferEventConnections);
        this.parent.getDataConnections().removeAll(this.transferDataConnections);
        this.subapp.getSubAppNetwork().getDataConnections().addAll(this.transferDataConnections);
        this.parent.getAdapterConnections().removeAll(this.transferAdapterConnections);
        this.subapp.getSubAppNetwork().getAdapterConnections().addAll(this.transferAdapterConnections);
        this.deleteCommands.undo();
    }

    private void checkConnections() {
        this.checkConnectionList((List)this.subapp.getSubAppNetwork().getEventConnections(), (List)this.transferEventConnections);
        this.checkConnectionList((List)this.subapp.getSubAppNetwork().getDataConnections(), (List)this.transferDataConnections);
        this.checkConnectionList((List)this.subapp.getSubAppNetwork().getAdapterConnections(), (List)this.transferAdapterConnections);
    }

    private void createMappCommands() {
        if (this.subapp.isMapped()) {
            for (FBNetworkElement fbNetworkElement : this.elements) {
                this.mappCommands.add((Command)new MapToCommand(fbNetworkElement, this.subapp.getResource()));
            }
        }
    }

    private <T extends Connection> void checkConnectionList(List<T> connectionList, List<T> transferConnectionList) {
        for (Connection connection : connectionList) {
            if (connection.getSourceElement() != this.subapp && connection.getDestinationElement() != this.subapp) {
                transferConnectionList.add(connection);
                continue;
            }
            this.deleteCommands.add((Command)new DeleteConnectionCommand(connection));
            if (connection.getSourceElement() == this.subapp && connection.getDestinationElement() == this.subapp) {
                for (Connection inboundConn : connection.getSource().getInputConnections()) {
                    for (Connection outboundConn : connection.getDestination().getOutputConnections()) {
                        this.createCommands.add((Command)this.createConnCreateCmd(inboundConn.getSource(), outboundConn.getDestination()));
                    }
                }
                continue;
            }
            if (connection.getSourceElement() == this.subapp) {
                for (Connection inboundConn : connection.getSource().getInputConnections()) {
                    this.createCommands.add((Command)this.createConnCreateCmd(inboundConn.getSource(), connection.getDestination()));
                }
                continue;
            }
            if (connection.getDestinationElement() != this.subapp) continue;
            for (Connection outboundConn : connection.getDestination().getOutputConnections()) {
                this.createCommands.add((Command)this.createConnCreateCmd(connection.getSource(), outboundConn.getDestination()));
            }
        }
    }

    private AbstractConnectionCreateCommand createConnCreateCmd(IInterfaceElement source, IInterfaceElement destination) {
        EventConnectionCreateCommand cmd = null;
        if (source instanceof Event) {
            cmd = new EventConnectionCreateCommand(this.parent);
        } else if (source instanceof AdapterDeclaration) {
            cmd = new AdapterConnectionCreateCommand(this.parent);
        } else if (source instanceof VarDeclaration) {
            cmd = new DataConnectionCreateCommand(this.parent);
        }
        if (cmd != null) {
            cmd.setSource(source);
            cmd.setDestination(destination);
        }
        return cmd;
    }

    private void adjustFBNElementPosition(int x, int y) {
        for (FBNetworkElement fbNetworkElement : this.elements) {
            fbNetworkElement.setX(fbNetworkElement.getX() + x);
            fbNetworkElement.setY(fbNetworkElement.getY() + y);
        }
    }
}

