/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import org.eclipse.fordiac.ide.application.ApplicationPlugin;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editors.SubAppNetworkEditor;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.fordiac.ide.ui.controls.editors.EditorFilter;
import org.eclipse.fordiac.ide.ui.controls.editors.EditorUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CommandUtil {
    public static IEditorInput closeOpenedSubApp(FBNetwork network) {
        EditorFilter filter = editor -> editor instanceof DiagramEditorWithFlyoutPalette && network.equals(((DiagramEditorWithFlyoutPalette)editor).getModel());
        IEditorPart editor2 = EditorUtils.findEditor((EditorFilter)filter);
        if (editor2 != null) {
            IEditorInput input = editor2.getEditorInput();
            EditorUtils.CloseEditor.run(editor2);
            return input;
        }
        return null;
    }

    public static void openSubAppEditor(IEditorInput input) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart part = Abstract4DIACUIPlugin.getCurrentActiveEditor();
        try {
            activePage.openEditor(input, SubAppNetworkEditor.class.getName());
        }
        catch (PartInitException e) {
            ApplicationPlugin.getDefault().logError(Messages.CommandUtil_ERROR_ReopenSubApp, (Exception)((Object)e));
        }
        activePage.activate((IWorkbenchPart)part);
    }
}

