/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class UnmapAction
extends SelectionAction
implements IObjectActionDelegate {
    public static final String ID = "Unmap";
    protected final List<FBNetworkElement> selectedNetworkElements = new ArrayList<FBNetworkElement>();

    public UnmapAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(Messages.UnmapAction_Unmap_Label);
    }

    public void run() {
        CommandStack stack = this.getCommandStack();
        CompoundCommand cmd = new CompoundCommand();
        cmd.setLabel(Messages.UnmapAction_Unmap_Label);
        for (FBNetworkElement element : this.selectedNetworkElements) {
            UnmapCommand unmapCmd = new UnmapCommand(element);
            if (!unmapCmd.canExecute()) continue;
            cmd.add((Command)unmapCmd);
        }
        if (stack != null) {
            stack.execute((Command)cmd);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected boolean calculateEnabled() {
        this.selectedNetworkElements.clear();
        for (Object selected : this.getSelectedObjects()) {
            if (!(selected instanceof AbstractFBNElementEditPart)) continue;
            AbstractFBNElementEditPart ep = (AbstractFBNElementEditPart)((Object)selected);
            this.checkSelectedModelElement(ep.getModel());
        }
        return this.selectedNetworkElements.size() > 0;
    }

    protected void checkSelectedModelElement(FBNetworkElement model) {
        if (model.isMapped()) {
            this.selectedNetworkElements.add(model);
        }
    }
}

