/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.ide.processors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.ide.processors.IEditableReportProcessor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractCachingStringProcessor
implements IEditableReportProcessor {
    private final String directive;
    private final String name;
    private final String editLabel;

    public AbstractCachingStringProcessor(String directive, String name, String editLabel) {
        this.directive = directive;
        this.name = name;
        this.editLabel = editLabel;
    }

    public AbstractCachingStringProcessor(IProcessorDescriptor descriptor) {
        this(descriptor.getDirective(), descriptor.getName(), "Please remove any irrelevant or sensitive data.");
    }

    public final boolean canContribute(IStatus status, IEclipseContext context) {
        String contextKey = String.valueOf(this.getContextKey()) + ".canContribute";
        if (context.containsKey(contextKey)) {
            return (Boolean)context.get(contextKey);
        }
        boolean canContribute = this.canContribute(status);
        context.set(contextKey, (Object)canContribute);
        return canContribute;
    }

    protected abstract boolean canContribute(IStatus var1);

    public final void process(IReport report, IStatus status, IEclipseContext context) {
        String value = (String)context.get(this.getContextKey());
        if (value == null) {
            value = this.process(status);
            context.set(this.getContextKey(), (Object)value);
        }
        report.getAuxiliaryInformation().put((Object)this.directive, (Object)value);
    }

    protected abstract String process(IStatus var1);

    protected String getContextKey() {
        return "processor." + this.directive + ".value";
    }

    @Override
    public IEditableReportProcessor.EditResult edit(IStatus status, IEclipseContext context, Shell parent) {
        String information = (String)context.get(this.getContextKey());
        EditDialog dialog = new EditDialog(information, parent);
        if (dialog.open() != 0) {
            return IEditableReportProcessor.EditResult.CANCELED;
        }
        String newInformation = dialog.getValue();
        if (information.equals(newInformation)) {
            return IEditableReportProcessor.EditResult.UNMODIFIED;
        }
        context.set(this.getContextKey(), (Object)newInformation);
        return IEditableReportProcessor.EditResult.MODIFIED;
    }

    @Override
    public void reset(IStatus status, IEclipseContext context) {
        context.remove(this.getContextKey());
    }

    private class EditDialog
    extends Dialog {
        private static final int SIZE_HINT_WIDTH = 500;
        private static final int SIZE_HINT_HEIGHT = 260;
        private StyledText editText;
        private String value;

        protected EditDialog(String value, Shell parentShell) {
            super(parentShell);
            this.setShellStyle(68720);
            this.value = value;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Edit '" + AbstractCachingStringProcessor.this.name + "'");
        }

        protected Control createDialogArea(Composite parent) {
            GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
            Label label = new Label(parent, 0);
            label.setText(AbstractCachingStringProcessor.this.editLabel);
            GridDataFactory.fillDefaults().align(0x1000000, 4).grab(true, false).applyTo((Control)label);
            this.editText = new StyledText(parent, 2818);
            this.editText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
            this.editText.setAlwaysShowScrollBars(false);
            this.editText.setText(this.value);
            GridDataFactory.fillDefaults().align(4, 4).hint(500, 260).grab(true, true).applyTo((Control)this.editText);
            return parent;
        }

        protected void okPressed() {
            this.value = this.editText.getText();
            super.okPressed();
        }

        public String getValue() {
            return this.value;
        }
    }
}

