/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class EmfPreferences {
    public static <T> T listen(String nodeQualifier, EObject eObject, Set<EAttribute> attributes) {
        ScopedPreferenceStore instanceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, nodeQualifier);
        EmfPreferences.loadFromPreferences(instanceStore, eObject, attributes);
        EmfPreferences.registerPreferenceStore2EObjectChangeListener(instanceStore, eObject, attributes);
        EmfPreferences.registerEObjectToPreferencesChangeListener(instanceStore, eObject, attributes);
        return (T)eObject;
    }

    private static void loadFromPreferences(ScopedPreferenceStore store, EObject eObject, Set<EAttribute> attributes) {
        eObject.eSetDeliver(false);
        for (EAttribute attr : attributes) {
            EDataType type = attr.getEAttributeType();
            String key = attr.getName();
            String value = StringUtils.trimToNull((String)store.getString(key));
            try {
                if (value == null) {
                    eObject.eUnset((EStructuralFeature)attr);
                    continue;
                }
                if (attr.isMany()) {
                    List list = (List)eObject.eGet((EStructuralFeature)attr);
                    for (String s : EmfPreferences.convert(value)) {
                        Object data = EcoreUtil.createFromString((EDataType)type, (String)s);
                        list.add(data);
                    }
                    continue;
                }
                Object data = EcoreUtil.createFromString((EDataType)type, (String)value);
                if (data == null) {
                    eObject.eUnset((EStructuralFeature)attr);
                    continue;
                }
                eObject.eSet((EStructuralFeature)attr, data);
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_PARSE_PREFERENCE_VALUE, (Throwable)e, (Object[])new Object[]{attr, value});
            }
        }
        eObject.eSetDeliver(true);
    }

    private static void registerEObjectToPreferencesChangeListener(final ScopedPreferenceStore store, EObject eObject, final Set<EAttribute> attributes) {
        eObject.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                Object value;
                Object feature = msg.getFeature();
                if (!(feature instanceof EAttribute)) {
                    return;
                }
                EAttribute attr = (EAttribute)feature;
                if (!attributes.contains(attr)) {
                    return;
                }
                String key = attr.getName();
                EDataType type = attr.getEAttributeType();
                String data = EcoreUtil.convertToString((EDataType)type, (Object)(value = msg.getNewValue()));
                if (data == null) {
                    store.setToDefault(key);
                } else {
                    store.putValue(key, data);
                }
            }
        });
    }

    private static void registerPreferenceStore2EObjectChangeListener(ScopedPreferenceStore store, final EObject eObject, final Set<EAttribute> attributes) {
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                EStructuralFeature feature = eObject.eClass().getEStructuralFeature(property);
                if (feature != null && feature instanceof EAttribute) {
                    EAttribute attr = (EAttribute)feature;
                    if (!attributes.contains(attr)) {
                        return;
                    }
                    EDataType type = attr.getEAttributeType();
                    String string = EcoreUtil.convertToString((EDataType)type, (Object)event.getNewValue());
                    Object value = EcoreUtil.createFromString((EDataType)type, (String)string);
                    eObject.eSet(feature, value);
                }
            }
        });
    }

    static List<String> convert(String string) {
        return Splitter.on((String)";#;").omitEmptyStrings().trimResults().splitToList((CharSequence)string);
    }

    static String convert(List<String> strings) {
        return Joiner.on((String)";#;").skipNulls().join(strings);
    }
}

