/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.notifications;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.UIUtils;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.OpenReviewDialogHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.NotificationAction;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.mylyn.commons.workbench.forms.ScalingHyperlink;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class NewEventNotification
extends Notification {
    private ILogEventGroup group;
    private ImageRegistry registry;
    private IEclipseContext context;
    private OpenReviewDialogHandler handler;

    @Inject
    public NewEventNotification(ILogEventGroup group, ImageRegistry registry, IEventBroker broker, IEclipseContext context, OpenReviewDialogHandler handler) {
        super("org.eclipse.epp.logging.aeri.notifications.event.newProblem", broker);
        this.group = group;
        this.registry = registry;
        this.context = context;
        this.handler = handler;
    }

    public Control createControl(Composite parent) {
        GridDataFactory asis = GridDataFactory.fillDefaults().align(4, 128);
        GridDataFactory w400 = GridDataFactory.fillDefaults().hint(400, -1).grab(false, false).align(4, 128);
        GridDataFactory w360 = GridDataFactory.fillDefaults().hint(370, -1).grab(false, false).align(4, 128);
        Composite container = new Composite(parent, 524288);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(container);
        w400.applyTo((Control)container);
        Link label = new Link(container, 524352);
        label.setText(this.getLabel());
        label.setForeground(CommonColors.TEXT_QUOTED);
        w400.applyTo((Control)label);
        Link description = new Link(container, 524352);
        description.setText(this.getDescription());
        w400.applyTo((Control)description);
        Composite serverSections = new Composite(container, 524288);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(serverSections);
        for (ILogEvent event : this.group.getEvents()) {
            IServerDescriptor server = event.getServer();
            if (!server.isActive()) continue;
            IProblemState interest = event.getInterest();
            Label icon = new Label(serverSections, 524288);
            Image image = UIUtils.decorate(server, interest.getStatus(), this.registry);
            icon.setImage(image);
            asis.applyTo((Control)icon);
            Link response = new Link(serverSections, 524352);
            w360.applyTo((Control)response);
            response.setText(this.getMessage(server, interest));
            response.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Browsers.openInExternalBrowser(e.text);
                }
            });
        }
        Link label2 = new Link(container, 524352);
        label2.setText(Messages.LINK_TEXT_DO_YOU_WANT_TO_REPORT_ERROR);
        w400.applyTo((Control)label);
        this.createLinkSection(container);
        return container;
    }

    private String getMessage(IServerDescriptor server, IProblemState interest) {
        String message = interest.getMessage();
        if (!StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        switch (interest.getStatus()) {
            case NEW: {
                return Formats.format(Messages.LINK_TEXT_DEFAULT_MESSAGE_NEW_PROBLEM, server.getName());
            }
            case UNCONFIRMED: {
                return Formats.format(Messages.LINK_TEXT_DEFAULT_MESSAGE_UNCONFIRMED_PROBLEM, server.getName());
            }
            case CONFIRMED: {
                return Formats.format(Messages.LINK_TEXT_DEFAULT_MESSAGE_CONFIRMED_PROBLEM, server.getName());
            }
            case NEEDINFO: {
                return Formats.format(Messages.LINK_TEXT_DEFAULT_MESSAGE_NEEDINFO_PROBLEM, server.getName());
            }
            case FIXED: {
                return Formats.format(Messages.LINK_TEXT_DEFAULT_MESSAGE_FIXED_PROBLEM, server.getName());
            }
            case IGNORED: {
                return Formats.format(Messages.LINK_TEXT_DEFAULT_MESSAGE_IGNORED_PROBLEM, server.getName());
            }
            case INVALID: {
                return Formats.format(Messages.LINK_TEXT_DEFAULT_MESSAGE_INVALID_PROBLEM, server.getName());
            }
            case FAILURE: {
                return Formats.format(Messages.LINK_TEXT_DEFAULT_MESSAGE_FAILURE, server.getName());
            }
        }
        return "";
    }

    protected void createLinkSection(Composite container) {
        Color linkColor = JFaceResources.getColorRegistry().get("HYPERLINK_COLOR");
        Composite linksComposite = new Composite(container, 524288);
        GridDataFactory.fillDefaults().align(0x1000008, 128).applyTo((Control)linksComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(40, 0).applyTo(linksComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)new Label(linksComposite, 0));
        ScalingHyperlink showLink = new ScalingHyperlink(linksComposite, 524288);
        GridDataFactory.swtDefaults().applyTo((Control)showLink);
        showLink.setText(Messages.LINK_TEXT_VIEW_DETAILS);
        showLink.setForeground(linkColor);
        showLink.registerMouseTrackListener();
        showLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NewEventNotification.this.closeWithEvent(null, null);
                ContextInjectionFactory.invoke((Object)NewEventNotification.this.handler, Execute.class, (IEclipseContext)NewEventNotification.this.context);
            }
        });
        ScalingHyperlink sendLink = new ScalingHyperlink(linksComposite, 524288);
        GridDataFactory.swtDefaults().applyTo((Control)sendLink);
        sendLink.setText(Messages.LINK_TEXT_SEND);
        sendLink.setForeground(linkColor);
        sendLink.registerMouseTrackListener();
        sendLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NewEventNotification.this.closeWithEvent("org/eclipse/epp/internal/logging/aeri/ui/event/send/group", NewEventNotification.this.group);
            }
        });
    }

    protected String getResponse(IServerDescriptor server, IProblemState interest) {
        switch (interest.getStatus()) {
            case NEW: {
                return Formats.format(Messages.NOTIFY_INTEREST_PROBLEM_NEW, server.getName(), interest.getMessage());
            }
            case UNCONFIRMED: {
                return Formats.format(Messages.NOTIFY_INTEREST_PROBLEM_UNCONFIRMED, server.getName(), interest.getMessage());
            }
            case CONFIRMED: {
                return Formats.format(Messages.NOTIFY_INTEREST_PROBLEM_CONFIRMED, server.getName(), interest.getMessage());
            }
            case NEEDINFO: {
                return Formats.format(Messages.NOTIFY_INTEREST_PROBLEM_NEEDINFO, server.getName(), interest.getMessage());
            }
            case FIXED: {
                return Formats.format(Messages.NOTIFY_INTEREST_PROBLEM_FIXED, server.getName(), interest.getMessage());
            }
            case IGNORED: {
                return Formats.format(Messages.NOTIFY_INTEREST_PROBLEM_IGNORED, server.getName(), interest.getMessage());
            }
            case INVALID: {
                return Formats.format(Messages.NOTIFY_INTEREST_PROBLEM_INVALID, server.getName(), interest.getMessage());
            }
            case FAILURE: {
                return Formats.format(Messages.NOTIFY_INTEREST_PROBLEM_FAILURE, server.getName(), interest.getMessage());
            }
        }
        return "";
    }

    @Override
    public String getTitle() {
        return Formats.format(Messages.NOTIFICATION_TITLE_NEW_EVENT, this.group.getStatus().getPlugin());
    }

    public String getLabel() {
        return Formats.format(Messages.NOTIFICATION_LABEL_NEW_EVENT, StringUtils.abbreviate((String)this.group.getStatus().getMessage(), (int)80));
    }

    public String getDescription() {
        Throwable exception = (Throwable)Preconditions.checkNotNull((Object)this.group.getStatus().getException());
        String exceptionMessage = (String)Optional.fromNullable((Object)exception.getMessage()).or((Object)"");
        String exceptionHeadline = StringUtils.abbreviate((String)Formats.format(Messages.NOTIFICATION_DESCRIPTION_NEW_EVENT, exception.getClass().getSimpleName(), exceptionMessage), (int)80);
        return exceptionHeadline;
    }

    @Override
    public List<NotificationAction> getActions() {
        return Collections.emptyList();
    }
}

