/*
 * Copyright (c) 2008, the JUNG Project and the Regents of the University
 * of California
 * All rights reserved.
 *
 * This software is open-source under the BSD license; see either
 * "license.txt" or
 * http://jung.sourceforge.net/license.txt for a description.
 */

package edu.uci.ics.jung.io.graphml;

/**
 * Provides some constants for element/attribute names in GraphML
 * 
 * @author Nathan Mittler - nathan.mittler@gmail.com
 */
public class GraphMLConstants {

    public static final String GRAPHML_NAME = "graphml";
    public static final String GRAPH_NAME = "graph";
    public static final String NODE_NAME = "node";
    public static final String EDGE_NAME = "edge";
    public static final String ENDPOINT_NAME = "endpoint";
    public static final String HYPEREDGE_NAME = "hyperedge";
    public static final String PORT_NAME = "port";
    public static final String KEY_NAME = "key";
    public static final String DATA_NAME = "data";
    public static final String ALL_NAME = "all";
    public static final String ID_NAME = "id";
    public static final String FOR_NAME = "for";
    public static final String DESC_NAME = "desc";
    public static final String DEFAULT_NAME = "default";
    public static final String ATTRNAME_NAME = "attr.name";
    public static final String ATTRTYPE_NAME = "attr.type";
    public static final String NAME_NAME = "name";
    public static final String EDGEDEFAULT_NAME = "edgedefault";
    public static final String TYPE_NAME = "type";
    public static final String IN_NAME = "in";
    public static final String OUT_NAME = "out";
    public static final String UNDIR_NAME = "undir";
    public static final String DIRECTED_NAME = "directed";
    public static final String UNDIRECTED_NAME = "undirected";
    public static final String SOURCE_NAME = "source";
    public static final String TARGET_NAME = "target";
    public static final String SOURCEPORT_NAME = "sourceport";
    public static final String TARGETPORT_NAME = "targetport";
}
