# frozen_string_literal: true

# rubocop: disable BackgroundMigration/DictionaryFile -- queued/introduced before the rule is introduced

class Requeue2BackfillHasRemediationsOfVulnerabilityReads < Gitlab::Database::Migration[2.2]
  milestone '16.7'

  MIGRATION = "BackfillHasRemediationsOfVulnerabilityReads"
  DELAY_INTERVAL = 2.minutes
  BATCH_SIZE = 10_000
  SUB_BATCH_SIZE = 50

  restrict_gitlab_migration gitlab_schema: :gitlab_main
  disable_ddl_transaction!

  def up
    # remove the original migration
    delete_batched_background_migration(MIGRATION, :vulnerability_reads, :vulnerability_id, [])

    queue_batched_background_migration(
      MIGRATION,
      :vulnerability_reads,
      :vulnerability_id,
      job_interval: DELAY_INTERVAL,
      batch_size: BATCH_SIZE,
      sub_batch_size: SUB_BATCH_SIZE
    )
  end

  def down
    delete_batched_background_migration(MIGRATION, :vulnerability_reads, :vulnerability_id, [])
  end
end
# rubocop: enable BackgroundMigration/DictionaryFile
