/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.MolleweideProjection;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.proj.SinusoidalProjection;

public class GoodeProjection
extends Projection {
    private static final double Y_COR = 0.0528;
    private static final double PHI_LIM = 0.7109307819790236;
    private SinusoidalProjection sinu = new SinusoidalProjection();
    private MolleweideProjection moll = new MolleweideProjection();

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        if (Math.abs(lpphi) <= 0.7109307819790236) {
            out = this.sinu.project(lplam, lpphi, out);
        } else {
            out = this.moll.project(lplam, lpphi, out);
            out.y = out.y - (lpphi >= 0.0 ? 0.0528 : -0.0528);
        }
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out = Math.abs(xyy) <= 0.7109307819790236 ? this.sinu.projectInverse(xyx, xyy, out) : this.moll.projectInverse(xyx, xyy += xyy >= 0.0 ? 0.0528 : -0.0528, out);
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Goode Homolosine";
    }
}

