/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.join;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class FiltersQParser
extends QParser {
    protected String getFiltersParamName() {
        return "param";
    }

    protected FiltersQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        BooleanQuery query = this.parseImpl();
        return !query.clauses().isEmpty() ? this.wrapSubordinateClause((Query)query) : this.noClausesQuery();
    }

    protected BooleanQuery parseImpl() throws SyntaxError {
        Map<QParser, BooleanClause.Occur> clauses = this.clauses();
        this.exclude(clauses.keySet());
        BooleanQuery.Builder builder = this.createBuilder();
        for (Map.Entry<QParser, BooleanClause.Occur> clause : clauses.entrySet()) {
            builder.add(this.unwrapQuery(clause.getKey().getQuery(), clause.getValue()), clause.getValue());
        }
        return builder.build();
    }

    protected BooleanQuery.Builder createBuilder() {
        return new BooleanQuery.Builder();
    }

    protected Query unwrapQuery(Query query, BooleanClause.Occur occur) {
        return query;
    }

    protected Query wrapSubordinateClause(Query subordinate) throws SyntaxError {
        return subordinate;
    }

    protected Query noClausesQuery() throws SyntaxError {
        return new MatchAllDocsQuery();
    }

    protected void exclude(Collection<QParser> clauses) {
        Map tagMap;
        HashSet<String> tagsToExclude = new HashSet<String>();
        String excludeTags = this.localParams.get("excludeTags");
        if (excludeTags != null) {
            tagsToExclude.addAll(StrUtils.splitSmart((String)excludeTags, (char)','));
        }
        Collection<Object> excludeSet = (tagMap = (Map)this.req.getContext().get("tags")) != null && !tagMap.isEmpty() && !tagsToExclude.isEmpty() ? this.excludeSet(tagMap, tagsToExclude) : Collections.emptySet();
        clauses.removeAll(excludeSet);
    }

    protected Map<QParser, BooleanClause.Occur> clauses() throws SyntaxError {
        String[] params = this.localParams.getParams(this.getFiltersParamName());
        if (params != null && params.length == 0) {
            throw new SyntaxError("Local parameter " + this.getFiltersParamName() + " is not defined for " + this.stringIncludingLocalParams);
        }
        IdentityHashMap<QParser, BooleanClause.Occur> clauses = new IdentityHashMap<QParser, BooleanClause.Occur>();
        for (String filter : params == null ? new String[]{} : params) {
            if (filter == null || filter.length() == 0) continue;
            QParser parser = this.subQuery(filter, null);
            clauses.put(parser, BooleanClause.Occur.FILTER);
        }
        String queryText = this.localParams.get("v");
        if (queryText != null && queryText.length() > 0) {
            QParser parser = this.subQuery(queryText, null);
            clauses.put(parser, BooleanClause.Occur.MUST);
        }
        return clauses;
    }

    private Collection<QParser> excludeSet(Map<?, ?> tagMap, Set<String> tagsToExclude) {
        IdentityHashMap<QParser, Boolean> excludeSet = new IdentityHashMap<QParser, Boolean>();
        for (String excludeTag : tagsToExclude) {
            Object olst = tagMap.get(excludeTag);
            if (!(olst instanceof Collection)) continue;
            for (Object o : (Collection)olst) {
                if (!(o instanceof QParser)) continue;
                QParser qp = (QParser)o;
                excludeSet.put(qp, Boolean.TRUE);
            }
        }
        return excludeSet.keySet();
    }
}

