/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.NumberFormatPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.intl.ToIntlMathematicalValue;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormatObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class NumberFormatPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<NumberFormatPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new NumberFormatPrototypeBuiltins();

    protected NumberFormatPrototypeBuiltins() {
        super(JSNumberFormat.PROTOTYPE_NAME, NumberFormatPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, NumberFormatPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return NumberFormatPrototypeBuiltinsFactory.JSNumberFormatResolvedOptionsNodeGen.create(context, builtin, NumberFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return NumberFormatPrototypeBuiltinsFactory.JSNumberFormatFormatToPartsNodeGen.create(context, builtin, NumberFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return NumberFormatPrototypeBuiltinsFactory.JSNumberFormatFormatRangeNodeGen.create(context, builtin, NumberFormatPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 3: {
                return NumberFormatPrototypeBuiltinsFactory.JSNumberFormatFormatRangeToPartsNodeGen.create(context, builtin, NumberFormatPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 4: {
                return NumberFormatPrototypeBuiltinsFactory.JSNumberFormatGetFormatNodeGen.create(context, builtin, NumberFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum NumberFormatPrototype implements BuiltinEnum<NumberFormatPrototype>
    {
        resolvedOptions(0),
        formatToParts(1),
        formatRange(2),
        formatRangeToParts(2),
        format(0);

        private final int length;

        private NumberFormatPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 1 -> 9;
                case 2, 3 -> 14;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }

        @Override
        public boolean isGetter() {
            return this == format;
        }
    }

    public static abstract class JSNumberFormatResolvedOptionsNode
    extends JSBuiltinNode {
        public JSNumberFormatResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doResolvedOptions(JSNumberFormatObject numberFormat) {
            return JSNumberFormat.resolvedOptions(this.getContext(), this.getRealm(), numberFormat);
        }

        @Fallback
        public Object throwTypeError(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected(JSNumberFormat.CLASS_NAME);
        }
    }

    public static abstract class JSNumberFormatFormatToPartsNode
    extends JSBuiltinNode {
        public JSNumberFormatFormatToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doFormatToParts(JSNumberFormatObject numberFormat, Object value, @Cached(value="create(false)") ToIntlMathematicalValue toIntlMVValueNode) {
            Number n = toIntlMVValueNode.executeNumber(value);
            return JSNumberFormat.formatToParts(this.getContext(), this.getRealm(), numberFormat, n);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected(JSNumberFormat.CLASS_NAME);
        }
    }

    public static abstract class JSNumberFormatFormatRangeNode
    extends JSBuiltinNode {
        public JSNumberFormatFormatRangeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public TruffleString doFormatRange(JSNumberFormatObject numberFormat, Object start, Object end, @Cached(value="create(true)") ToIntlMathematicalValue startToIntlMVNode, @Cached(value="create(true)") ToIntlMathematicalValue endToIntlMVNode, @Cached InlinedBranchProfile errorBranch) {
            if (start == Undefined.instance || end == Undefined.instance) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("invalid range");
            }
            Number x = startToIntlMVNode.executeNumber(start);
            Number y = endToIntlMVNode.executeNumber(end);
            return JSNumberFormat.formatRange(numberFormat, x, y);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object start, Object end) {
            throw Errors.createTypeErrorTypeXExpected(JSNumberFormat.CLASS_NAME);
        }
    }

    public static abstract class JSNumberFormatFormatRangeToPartsNode
    extends JSBuiltinNode {
        public JSNumberFormatFormatRangeToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doFormatRangeToParts(JSNumberFormatObject numberFormat, Object start, Object end, @Cached(value="create(true)") ToIntlMathematicalValue startToIntlMVNode, @Cached(value="create(true)") ToIntlMathematicalValue endToIntlMVNode, @Cached InlinedBranchProfile errorBranch) {
            if (start == Undefined.instance || end == Undefined.instance) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeError("invalid range");
            }
            Number x = startToIntlMVNode.executeNumber(start);
            Number y = endToIntlMVNode.executeNumber(end);
            return JSNumberFormat.formatRangeToParts(this.getContext(), this.getRealm(), numberFormat, x, y);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object start, Object end) {
            throw Errors.createTypeErrorTypeXExpected(JSNumberFormat.CLASS_NAME);
        }
    }

    public static abstract class JSNumberFormatGetFormatNode
    extends JSBuiltinNode {
        static final HiddenKey BOUND_OBJECT_KEY = new HiddenKey(Strings.toJavaString(JSNumberFormat.CLASS_NAME));
        @Node.Child
        private PropertySetNode setBoundObjectNode;

        protected JSNumberFormatGetFormatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.setBoundObjectNode = PropertySetNode.createSetHidden(BOUND_OBJECT_KEY, context);
        }

        @Specialization
        public Object doNumberFormat(JSNumberFormatObject numberFormatObj, @Cached InlinedBranchProfile errorBranch) {
            JSNumberFormat.InternalState state = numberFormatObj.getInternalState();
            if (state == null) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorMethodCalledOnNonObjectOrWrongType("format");
            }
            if (state.getBoundFormatFunction() == null) {
                JSFunctionData formatFunctionData = this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.NumberFormatFormat, c -> JSNumberFormatGetFormatNode.createFormatFunctionData(c));
                JSFunctionObject formatFn = JSFunction.create(this.getRealm(), formatFunctionData);
                this.setBoundObjectNode.setValue((Object)formatFn, (Object)numberFormatObj);
                state.setBoundFormatFunction(formatFn);
            }
            return state.getBoundFormatFunction();
        }

        @Fallback
        public Object doIncompatibleReceiver(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected(JSNumberFormat.CLASS_NAME);
        }

        private static JSFunctionData createFormatFunctionData(final JSContext context) {
            return JSFunctionData.createCallOnly(context, (CallTarget)new JavaScriptRootNode(context.getLanguage(), null, null){
                @Node.Child
                private PropertyGetNode getBoundObjectNode;
                @Node.Child
                private ToIntlMathematicalValue toIntlMVValueNode;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.getBoundObjectNode = PropertyGetNode.createGetHidden(BOUND_OBJECT_KEY, context);
                    this.toIntlMVValueNode = ToIntlMathematicalValue.create(false);
                }

                public Object execute(VirtualFrame frame) {
                    Object[] arguments = frame.getArguments();
                    JSNumberFormatObject thisObj = (JSNumberFormatObject)((Object)this.getBoundObjectNode.getValue(JSArguments.getFunctionObject(arguments)));
                    JSDynamicObject n = JSArguments.getUserArgumentCount(arguments) > 0 ? JSArguments.getUserArgument(arguments, 0) : Undefined.instance;
                    return JSNumberFormat.formatMV(thisObj, this.toIntlMVValueNode.executeNumber((Object)n));
                }
            }.getCallTarget(), 1, Strings.EMPTY_STRING);
        }
    }
}

