/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.MaybeBindDescriptorNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.TruffleWeakReference;

public final class TpSlotRepr {
    private TpSlotRepr() {
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CallDispatchers.class})
    static abstract class ReprPythonSlotDispatcherNode
    extends PythonDispatchers.PythonSlotDispatcherNodeBase {
        ReprPythonSlotDispatcherNode() {
        }

        final Object execute(VirtualFrame frame, Node inliningTarget, Object callable, Object type, Object self) {
            assert (!(callable instanceof TruffleWeakReference));
            assert (!(type instanceof TruffleWeakReference));
            return this.executeImpl(frame, inliningTarget, callable, type, self);
        }

        abstract Object executeImpl(VirtualFrame var1, Node var2, Object var3, Object var4, Object var5);

        @Specialization(guards={"isSingleContext()", "callee == cachedCallee", "isSimpleSignature(cachedCallee, 1)"}, limit="getCallSiteInlineCacheMaxDepth()", assumptions={"cachedCallee.getCodeStableAssumption()"})
        protected static Object doCachedPFunction(VirtualFrame frame, Node inliningTarget, PFunction callee, Object type, Object self, @Cached(value="callee") PFunction cachedCallee, @Cached(value="createDirectCallNodeFor(callee)") DirectCallNode callNode, @Cached CallDispatchers.FunctionDirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(1);
            PArguments.setArgument(arguments, 0, self);
            return invoke.execute(frame, inliningTarget, callNode, cachedCallee, arguments);
        }

        @Specialization(replaces={"doCachedPFunction"})
        @HostCompilerDirectives.InliningCutoff
        static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object callableObj, Object type, Object self, @Cached MaybeBindDescriptorNode bindDescriptorNode, @Cached(inline=false) CallNode callNode, @Cached(inline=false) ObjectNodes.DefaultObjectReprNode defaultRepr) {
            Object[] arguments;
            Object callable;
            Object bound;
            try {
                bound = bindDescriptorNode.execute((Frame)frame, inliningTarget, callableObj, self, type);
            }
            catch (AbstractTruffleException e) {
                return defaultRepr.executeCached((Frame)frame, self);
            }
            if (bound instanceof BoundDescriptor) {
                BoundDescriptor boundDescr = (BoundDescriptor)bound;
                callable = boundDescr.descriptor;
                arguments = PythonUtils.EMPTY_OBJECT_ARRAY;
            } else {
                callable = bound;
                arguments = new Object[]{self};
            }
            return callNode.execute((Frame)frame, callable, arguments);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class CallSlotReprPythonNode
    extends Node {
        CallSlotReprPythonNode() {
        }

        abstract Object execute(VirtualFrame var1, TpSlot.TpSlotPythonSingle var2, Object var3);

        @Specialization
        static Object doIt(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Bind Node inliningTarget, @Cached ReprPythonSlotDispatcherNode dispatcherNode) {
            return dispatcherNode.execute(frame, inliningTarget, slot.getCallable(), slot.getType(), self);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotReprNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "repr");

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4);

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin<?> slot, Object self, @Cached(value="slot") TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createSlotNode()") PythonUnaryBuiltinNode slotNode) {
            return slotNode.execute(frame, self);
        }

        @Specialization
        static Object callPython(VirtualFrame frame, TpSlot.TpSlotPythonSingle slot, Object self, @Cached(inline=false) CallSlotReprPythonNode callSlotNode) {
            return callSlotNode.execute(frame, slot, self);
        }

        @Specialization
        static Object callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotCExtNative slot, Object self, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached(inline=false) ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            PythonContext.PythonThreadState state = getThreadStateNode.execute(inliningTarget);
            Object result = externalInvokeNode.call(frame, inliningTarget, state, C_API_TIMING, SpecialMethodNames.T___REPR__, slot.callable, toNativeNode.execute(self));
            return checkResultNode.execute(state, SpecialMethodNames.T___REPR__, toPythonNode.execute(result));
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin<?> slot, Object self, @Cached CallDispatchers.SimpleIndirectInvokeNode invoke) {
            Object[] arguments = PArguments.create(1);
            PArguments.setArgument(arguments, 0, self);
            RootCallTarget callTarget = PythonLanguage.get(inliningTarget).getBuiltinSlotCallTarget(slot.callTargetIndex);
            return invoke.execute((Frame)frame, inliningTarget, callTarget, arguments);
        }
    }
}

