/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

public final class ScriptEnvironment {
    public static final int ES_2015 = 6;
    public static final int ES_2016 = 7;
    public static final int ES_2017 = 8;
    public static final int ES_2018 = 9;
    public static final int ES_2019 = 10;
    public static final int ES_2020 = 11;
    public static final int ES_2021 = 12;
    public static final int ES_2022 = 13;
    public static final int ES_2023 = 14;
    public static final int ES_2024 = 15;
    public static final int ES_STAGING = Integer.MAX_VALUE;
    final boolean constAsVar;
    final boolean emptyStatements;
    final int ecmaScriptVersion;
    final FunctionStatementBehavior functionStatement;
    final boolean syntaxExtensions;
    final boolean scripting;
    final boolean shebang;
    final boolean strict;
    final boolean allowBigInt;
    final boolean annexB;
    final boolean classFields;
    final boolean importAttributes;
    final boolean importAssertions;
    final boolean privateFieldsIn;
    final boolean topLevelAwait;
    final boolean v8Intrinsics;
    final boolean sourcePhaseImports;

    public ScriptEnvironment(boolean strict, int ecmaScriptVersion, boolean emptyStatements, boolean syntaxExtensions, boolean scripting, boolean shebang, boolean constAsVar, boolean allowBigInt, boolean annexB, boolean classFields, boolean importAttributes, boolean importAssertions, boolean sourcePhaseImports, boolean privateFieldsIn, boolean topLevelAwait, boolean v8Intrinsics, FunctionStatementBehavior functionStatementBehavior) {
        this.constAsVar = constAsVar;
        this.emptyStatements = emptyStatements;
        this.functionStatement = functionStatementBehavior;
        this.syntaxExtensions = syntaxExtensions;
        this.strict = strict;
        this.scripting = scripting;
        this.shebang = shebang;
        this.ecmaScriptVersion = ecmaScriptVersion;
        this.allowBigInt = allowBigInt;
        this.annexB = annexB;
        this.classFields = classFields;
        this.importAttributes = importAttributes;
        this.importAssertions = importAssertions;
        this.sourcePhaseImports = sourcePhaseImports;
        this.privateFieldsIn = privateFieldsIn;
        this.topLevelAwait = topLevelAwait;
        this.v8Intrinsics = v8Intrinsics;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum FunctionStatementBehavior {
        ACCEPT,
        WARNING,
        ERROR;

    }

    public static final class Builder {
        private int ecmaScriptVersion = 6;
        private boolean constAsVar;
        private boolean emptyStatements;
        private boolean syntaxExtensions = true;
        private boolean scripting;
        private boolean shebang;
        private boolean strict;
        private boolean allowBigInt;
        private boolean annexB = true;
        private boolean classFields = true;
        private boolean importAttributes = false;
        private boolean importAssertions = false;
        private boolean sourcePhaseImports = false;
        private boolean privateFieldsIn = false;
        private boolean topLevelAwait = false;
        private boolean v8Intrinsics = false;
        private FunctionStatementBehavior functionStatementBehavior = FunctionStatementBehavior.ERROR;

        private Builder() {
        }

        public Builder ecmaScriptVersion(int ecmaScriptVersion) {
            this.ecmaScriptVersion = ecmaScriptVersion;
            return this;
        }

        public Builder constAsVar(boolean constAsVar) {
            this.constAsVar = constAsVar;
            return this;
        }

        public Builder emptyStatements(boolean emptyStatements) {
            this.emptyStatements = emptyStatements;
            return this;
        }

        public Builder syntaxExtensions(boolean syntaxExtensions) {
            this.syntaxExtensions = syntaxExtensions;
            return this;
        }

        public Builder scripting(boolean scripting) {
            this.scripting = scripting;
            return this;
        }

        public Builder shebang(boolean shebang) {
            this.shebang = shebang;
            return this;
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder allowBigInt(boolean allowBigInt) {
            this.allowBigInt = allowBigInt;
            return this;
        }

        public Builder annexB(boolean annexB) {
            this.annexB = annexB;
            return this;
        }

        public Builder classFields(boolean classFields) {
            this.classFields = classFields;
            return this;
        }

        public Builder importAttributes(boolean importAttributes) {
            this.importAttributes = importAttributes;
            return this;
        }

        public Builder importAssertions(boolean importAssertions) {
            this.importAssertions = importAssertions;
            return this;
        }

        public void sourcePhaseImports(boolean sourcePhaseImports) {
            this.sourcePhaseImports = sourcePhaseImports;
        }

        public Builder privateFieldsIn(boolean privateFieldsIn) {
            this.privateFieldsIn = privateFieldsIn;
            return this;
        }

        public Builder topLevelAwait(boolean topLevelAwait) {
            this.topLevelAwait = topLevelAwait;
            return this;
        }

        public Builder v8Intrinsics(boolean v8Intrinsics) {
            this.v8Intrinsics = v8Intrinsics;
            return this;
        }

        public Builder functionStatementBehavior(FunctionStatementBehavior functionStatementBehavior) {
            this.functionStatementBehavior = functionStatementBehavior;
            return this;
        }

        public ScriptEnvironment build() {
            return new ScriptEnvironment(this.strict, this.ecmaScriptVersion, this.emptyStatements, this.syntaxExtensions, this.scripting, this.shebang, this.constAsVar, this.allowBigInt, this.annexB, this.classFields, this.importAttributes, this.importAssertions, this.sourcePhaseImports, this.privateFieldsIn, this.topLevelAwait, this.v8Intrinsics, this.functionStatementBehavior);
        }
    }
}

