/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.std;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.Converter;

public class StdDelegatingSerializer
extends StdSerializer<Object> {
    protected final BeanProperty _property;
    protected final Converter<Object, ?> _converter;
    protected final JavaType _delegateType;
    protected final ValueSerializer<Object> _delegateSerializer;
    protected PropertySerializerMap _dynamicValueSerializers = PropertySerializerMap.emptyForProperties();

    public StdDelegatingSerializer(Converter<?, ?> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
        this._property = null;
    }

    public <T> StdDelegatingSerializer(Class<T> cls, Converter<T, ?> converter) {
        super(cls);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
        this._property = null;
    }

    public StdDelegatingSerializer(Converter<Object, ?> converter, JavaType delegateType, ValueSerializer<?> delegateSerializer, BeanProperty prop) {
        super(delegateType);
        this._converter = converter;
        this._delegateType = delegateType;
        this._delegateSerializer = delegateSerializer;
        this._property = prop;
    }

    protected StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType delegateType, ValueSerializer<?> delegateSerializer, BeanProperty prop) {
        ClassUtil.verifyMustOverride(StdDelegatingSerializer.class, this, "withDelegate");
        return new StdDelegatingSerializer(converter, delegateType, delegateSerializer, prop);
    }

    @Override
    public void resolve(SerializationContext ctxt) {
        if (this._delegateSerializer != null) {
            this._delegateSerializer.resolve(ctxt);
        }
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
        ValueSerializer<Object> delSer = this._delegateSerializer;
        JavaType delegateType = this._delegateType;
        if (delSer == null) {
            if (delegateType == null) {
                delegateType = this._converter.getOutputType(ctxt.getTypeFactory());
            }
            if (!delegateType.isJavaLangObject()) {
                delSer = ctxt.findValueSerializer(delegateType);
            }
        }
        if (delSer != null) {
            delSer = ctxt.handleSecondaryContextualization(delSer, property);
        }
        if (delSer == this._delegateSerializer && delegateType == this._delegateType && property == this._property) {
            return this;
        }
        return this.withDelegate(this._converter, delegateType, delSer, property);
    }

    public Converter<Object, ?> getConverter() {
        return this._converter;
    }

    @Override
    public ValueSerializer<?> getDelegatee() {
        return this._delegateSerializer;
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        Object delegateValue = this.convertValue(ctxt, value);
        if (delegateValue == null) {
            ctxt.defaultSerializeNullValue(gen);
            return;
        }
        ValueSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(delegateValue, ctxt);
        }
        ser.serialize(delegateValue, gen, ctxt);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        Object delegateValue = this.convertValue(ctxt, value);
        if (delegateValue == null) {
            ctxt.defaultSerializeNullValue(gen);
            return;
        }
        ValueSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(delegateValue, ctxt);
        }
        ser.serializeWithType(delegateValue, gen, ctxt, typeSer);
    }

    @Override
    public boolean isEmpty(SerializationContext ctxt, Object value) {
        Object delegateValue = this.convertValue(ctxt, value);
        if (delegateValue == null) {
            return true;
        }
        ValueSerializer<Object> ser = this._delegateSerializer;
        if (ser == null) {
            ser = this._findSerializer(value, ctxt);
        }
        return ser.isEmpty(ctxt, delegateValue);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        if (this._delegateSerializer != null) {
            this._delegateSerializer.acceptJsonFormatVisitor(visitor, typeHint);
        }
    }

    protected Object convertValue(SerializationContext ctxt, Object value) {
        return this._converter.convert(ctxt, value);
    }

    protected ValueSerializer<Object> _findSerializer(Object value, SerializationContext ctxt) {
        Class<?> cc = value.getClass();
        PropertySerializerMap.SerializerAndMapResult result = this._dynamicValueSerializers.findAndAddSecondarySerializer(cc, ctxt, this._property);
        if (this._dynamicValueSerializers != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }
}

