/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import schemacrawler.crawl.ImmutableJdbcDriverProperty;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import us.fatehi.utility.Utility;
import us.fatehi.utility.property.BaseProductVersion;

final class MutableJdbcDriverInfo
extends BaseProductVersion
implements JdbcDriverInfo {
    private static final long serialVersionUID = 8030156654422512161L;
    private final String connectionUrl;
    private final int driverMajorVersion;
    private final int driverMinorVersion;
    private final int jdbcMajorVersion;
    private final int jdbcMinorVersion;
    private final String driverClassName;
    private final boolean jdbcCompliant;
    private final Set<ImmutableJdbcDriverProperty> jdbcDriverProperties;

    public MutableJdbcDriverInfo(String driverName, String driverClassName, String driverVersion, int driverMajorVersion, int driverMinorVersion, int jdbcMajorVersion, int jdbcMinorVersion, boolean jdbcCompliant, String connectionUrl) {
        super(driverName, driverVersion);
        this.driverClassName = Objects.requireNonNull(driverClassName, "No database driver Java class name provided");
        this.driverMajorVersion = driverMajorVersion;
        this.driverMinorVersion = driverMinorVersion;
        this.jdbcMajorVersion = jdbcMajorVersion;
        this.jdbcMinorVersion = jdbcMinorVersion;
        this.jdbcCompliant = jdbcCompliant;
        this.jdbcDriverProperties = new HashSet<ImmutableJdbcDriverProperty>();
        this.connectionUrl = Utility.requireNotBlank((String)connectionUrl, (String)"No database connection URL provided");
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public Collection<JdbcDriverProperty> getDriverProperties() {
        ArrayList<JdbcDriverProperty> properties = new ArrayList<JdbcDriverProperty>(this.jdbcDriverProperties);
        properties.sort(Comparator.naturalOrder());
        return properties;
    }

    @Override
    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    @Override
    public int getJdbcMinorVersion() {
        return this.jdbcMinorVersion;
    }

    @Override
    public boolean hasDriverClassName() {
        return !Utility.isBlank((String)this.driverClassName);
    }

    @Override
    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- driver: ").append(this.getProductName()).append(' ').append(this.getProductVersion()).append(System.lineSeparator());
        info.append("-- driver class: ").append(this.getDriverClassName()).append(System.lineSeparator());
        info.append("-- url: ").append(this.getConnectionUrl()).append(System.lineSeparator());
        return info.toString();
    }

    void addJdbcDriverProperty(ImmutableJdbcDriverProperty jdbcDriverProperty) {
        this.jdbcDriverProperties.add(jdbcDriverProperty);
    }
}

