/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline
@GenerateCached(value=false)
public abstract class PyUnicodeAsEncodedString
extends PNodeWithContext {
    public static final String ENC_UTF_8 = "utf_8";
    public static final String ENC_UTF_16 = "utf_16";
    public static final String ENC_UTF_32 = "utf_32";
    public static final String ENC_UTF8 = "utf8";
    public static final String ENC_UTF16 = "utf16";
    public static final String ENC_UTF32 = "utf32";
    public static final String ENC_ASCII = "ascii";
    public static final String ENC_US_ASCII = "us_ascii";
    public static final String ENC_LATIN1 = "latin1";
    public static final String ENC_LATIN_1 = "latin_1";
    public static final String ENC_ISO_8859_1 = "iso_8859_1";
    public static final String ENC_ISO8859_1 = "iso8859_1";

    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4, Object var5);

    public static boolean isCommon(TruffleString encoding, TruffleString.ToJavaStringNode toJavaStringNode) {
        switch (PyUnicodeAsEncodedString.toLowerCase(toJavaStringNode.execute((AbstractTruffleString)encoding))) {
            case "ascii": 
            case "iso8859_1": 
            case "iso_8859_1": 
            case "latin1": 
            case "latin_1": 
            case "us_ascii": 
            case "utf_8": 
            case "utf_16": 
            case "utf_32": 
            case "utf8": 
            case "utf16": 
            case "utf32": {
                return true;
            }
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static String toLowerCase(String s) {
        return s.toLowerCase();
    }

    @Specialization(guards={"isString(unicode)", "isCommon(encoding, toJavaStringNode)"})
    static Object doCommon(VirtualFrame frame, Object unicode, TruffleString encoding, TruffleString errors, @Cached.Shared @Cached(inline=false) CodecsModuleBuiltins.CodecsEncodeNode encodeNode, @Cached.Shared(value="ts2js") @Cached(inline=false) TruffleString.ToJavaStringNode toJavaStringNode) {
        return encodeNode.execute(frame, unicode, encoding, errors);
    }

    @Specialization(guards={"isString(unicode)", "!isCommon(encoding, toJavaStringNode)"})
    static Object doRegistry(VirtualFrame frame, Node inliningTarget, Object unicode, TruffleString encoding, TruffleString errors, @Cached.Exclusive @Cached(inline=false) CodecsModuleBuiltins.EncodeNode encodeNode, @Cached InlinedConditionProfile isBytesProfile, @Cached InlinedConditionProfile isByteArrayProfile, @Cached SequenceStorageNodes.CopyNode copyNode, @Cached(inline=false) WarningsModuleBuiltins.WarnNode warnNode, @Cached.Exclusive @Cached PRaiseNode raiseNode, @Cached.Shared(value="ts2js") @Cached(inline=false) TruffleString.ToJavaStringNode toJavaStringNode) {
        Object v = encodeNode.execute(frame, unicode, encoding, errors);
        if (isBytesProfile.profile(inliningTarget, v instanceof PBytes)) {
            return v;
        }
        if (isByteArrayProfile.profile(inliningTarget, v instanceof PByteArray)) {
            warnNode.warnFormat((Frame)frame, (Object)PythonErrorType.RuntimeWarning, ErrorMessages.ENCODER_S_RETURNED_S_INSTEAD_OF_BYTES, encoding, "bytearray");
            return PFactory.createBytes(PythonLanguage.get(inliningTarget), copyNode.execute(inliningTarget, ((PByteArray)v).getSequenceStorage()));
        }
        throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_ENCODER_RETURNED_P_INSTEAD_OF_BYTES, encoding, v);
    }

    @Specialization(guards={"isString(unicode)", "isNoValue(encoding)"})
    static Object doNoEncoding(VirtualFrame frame, Object unicode, PNone encoding, Object errors, @Cached.Shared @Cached(inline=false) CodecsModuleBuiltins.CodecsEncodeNode encodeNode) {
        return encodeNode.execute(frame, unicode, ENC_UTF8, errors);
    }

    @Specialization(guards={"!isString(unicode)"})
    static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object unicode, Object encoding, Object errors, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
        throw raiseNode.raiseBadInternalCall(inliningTarget);
    }
}

