/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser;

import com.oracle.graal.python.pegparser.AbstractParser;
import java.util.HashMap;

class RuleResultCache<T> {
    private final AbstractParser parser;
    private final HashMap<Integer, HashMap<Integer, CachedItem<T>>> mainCache;

    public RuleResultCache(AbstractParser parser) {
        this.parser = parser;
        this.mainCache = new HashMap();
    }

    public boolean hasResult(int pos, int ruleId) {
        return this.mainCache.containsKey(pos) && this.mainCache.get(pos).containsKey(ruleId);
    }

    public T getResult(int pos, int ruleId) {
        CachedItem<T> item = this.mainCache.get(pos).get(ruleId);
        this.parser.reset(item.endPos);
        return item.node;
    }

    public T putResult(int pos, int ruleId, T node) {
        HashMap posCache = this.mainCache.computeIfAbsent(pos, k -> new HashMap());
        posCache.put(ruleId, new CachedItem<T>(node, this.parser.mark()));
        return node;
    }

    public void clear() {
        this.mainCache.clear();
    }

    private static class CachedItem<T> {
        final T node;
        final int endPos;

        CachedItem(T node, int endPos) {
            this.node = node;
            this.endPos = endPos;
        }
    }
}

