/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.hostchooser;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.hostchooser.CandidateHost;
import com.amazon.redshift.hostchooser.GlobalHostStatusTracker;
import com.amazon.redshift.hostchooser.HostChooser;
import com.amazon.redshift.hostchooser.HostRequirement;
import com.amazon.redshift.util.HostSpec;
import com.amazon.redshift.util.RedshiftException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

class MultiHostChooser
implements HostChooser {
    private HostSpec[] hostSpecs;
    private final HostRequirement targetServerType;
    private int hostRecheckTime;
    private boolean loadBalance;

    MultiHostChooser(HostSpec[] hostSpecs, HostRequirement targetServerType, Properties info) {
        this.hostSpecs = hostSpecs;
        this.targetServerType = targetServerType;
        try {
            this.hostRecheckTime = RedshiftProperty.HOST_RECHECK_SECONDS.getInt(info) * 1000;
            this.loadBalance = RedshiftProperty.LOAD_BALANCE_HOSTS.getBoolean(info);
        }
        catch (RedshiftException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<CandidateHost> iterator() {
        Iterator<CandidateHost> res = this.candidateIterator();
        if (!res.hasNext()) {
            List<HostSpec> allHosts = Arrays.asList(this.hostSpecs);
            if (this.loadBalance) {
                allHosts = new ArrayList<HostSpec>(allHosts);
                Collections.shuffle(allHosts);
            }
            res = this.withReqStatus(this.targetServerType, allHosts).iterator();
        }
        return res;
    }

    private Iterator<CandidateHost> candidateIterator() {
        if (this.targetServerType != HostRequirement.preferSecondary) {
            return this.getCandidateHosts(this.targetServerType).iterator();
        }
        List<CandidateHost> secondaries = this.getCandidateHosts(HostRequirement.secondary);
        List<CandidateHost> any = this.getCandidateHosts(HostRequirement.any);
        if (secondaries.isEmpty()) {
            return any.iterator();
        }
        if (any.isEmpty()) {
            return secondaries.iterator();
        }
        if (secondaries.get(secondaries.size() - 1).equals(any.get(0))) {
            secondaries = this.rtrim(1, secondaries);
        }
        return this.append(secondaries, any).iterator();
    }

    private List<CandidateHost> getCandidateHosts(HostRequirement hostRequirement) {
        List<HostSpec> candidates = GlobalHostStatusTracker.getCandidateHosts(this.hostSpecs, hostRequirement, this.hostRecheckTime);
        if (this.loadBalance) {
            Collections.shuffle(candidates);
        }
        return this.withReqStatus(hostRequirement, candidates);
    }

    private List<CandidateHost> withReqStatus(final HostRequirement requirement, final List<HostSpec> hosts) {
        return new AbstractList<CandidateHost>(){

            @Override
            public CandidateHost get(int index) {
                return new CandidateHost((HostSpec)hosts.get(index), requirement);
            }

            @Override
            public int size() {
                return hosts.size();
            }
        };
    }

    private <T> List<T> append(final List<T> a, final List<T> b) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return index < a.size() ? a.get(index) : b.get(index - a.size());
            }

            @Override
            public int size() {
                return a.size() + b.size();
            }
        };
    }

    private <T> List<T> rtrim(final int size, final List<T> a) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return a.get(index);
            }

            @Override
            public int size() {
                return Math.max(0, a.size() - size);
            }
        };
    }
}

