/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractFarmHash;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.HashUtil;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.Preconditions;
import java.util.Objects;

class FarmHashNa
extends AbstractFarmHash {
    private static final long START_X = 95310865018149119L;
    private static final long START_Y = 2480279821605975764L;
    private static final long START_Z = 1390051526045402406L;
    private static final FarmHashNa INSTANCE = new FarmHashNaWithoutSeed();

    FarmHashNa() {
    }

    static Hasher64 create() {
        return INSTANCE;
    }

    static Hasher64 create(long seed) {
        return new FarmHashNaWithSeeds(-7286425919675154353L, seed);
    }

    static Hasher64 create(long seed0, long seed1) {
        return new FarmHashNaWithSeeds(seed0, seed1);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    @Override
    protected long hashBytesToLongLength65Plus(byte[] input, int off, int len) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        long x = 95310865018149119L;
        long y = 2480279821605975764L;
        long z = 1390051526045402406L;
        long v0 = 0L;
        long v1 = 0L;
        long w0 = 0L;
        long w1 = 0L;
        int end = off + (len - 1 & 0xFFFFFFC0);
        int last64offset = off + len - 64;
        x += ByteArrayUtil.getLong(input, off);
        do {
            b0 = ByteArrayUtil.getLong(input, off);
            b1 = ByteArrayUtil.getLong(input, off + 8);
            b2 = ByteArrayUtil.getLong(input, off + 16);
            b3 = ByteArrayUtil.getLong(input, off + 24);
            b4 = ByteArrayUtil.getLong(input, off + 32);
            b5 = ByteArrayUtil.getLong(input, off + 40);
            b6 = ByteArrayUtil.getLong(input, off + 48);
            b7 = ByteArrayUtil.getLong(input, off + 56);
            x = Long.rotateRight(x + y + v0 + b1, 37) * -5435081209227447693L ^ w1;
            y = Long.rotateRight(y + v1 + b6, 42) * -5435081209227447693L + v0 + b5;
            z = Long.rotateRight(z + w0, 33) * -5435081209227447693L;
            v1 *= -5435081209227447693L;
            v0 = (v1 += b0) + (b1 + b2);
            v1 += Long.rotateRight(x + w0 + v1 + b3, 21);
            v1 += Long.rotateRight(v0, 44);
            w0 = (w1 += z + b4) + (b5 + b6);
            w1 += Long.rotateRight(y + w1 + b2 + b7, 21);
            w1 += Long.rotateRight(w0, 44);
            v0 += b3;
            w0 += b7;
            long t = z;
            z = x;
            x = t;
        } while ((off += 64) != end);
        b0 = ByteArrayUtil.getLong(input, last64offset);
        b1 = ByteArrayUtil.getLong(input, last64offset + 8);
        b2 = ByteArrayUtil.getLong(input, last64offset + 16);
        b3 = ByteArrayUtil.getLong(input, last64offset + 24);
        b4 = ByteArrayUtil.getLong(input, last64offset + 32);
        b5 = ByteArrayUtil.getLong(input, last64offset + 40);
        b6 = ByteArrayUtil.getLong(input, last64offset + 48);
        b7 = ByteArrayUtil.getLong(input, last64offset + 56);
        return this.finalizeHash(x, y, z, v0, v1, w0 += (long)(len - 1 & 0x3F), w1, b0, b1, b2, b3, b4, b5, b6, b7);
    }

    @Override
    protected <T> long hashBytesToLongLength65Plus(T input, long off, long len, ByteAccess<T> access) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        long x = 95310865018149119L;
        long y = 2480279821605975764L;
        long z = 1390051526045402406L;
        long v0 = 0L;
        long v1 = 0L;
        long w0 = 0L;
        long w1 = 0L;
        long end = off + (len - 1L & 0xFFFFFFFFFFFFFFC0L);
        long last64offset = off + len - 64L;
        x += access.getLong(input, off);
        do {
            b0 = access.getLong(input, off);
            b1 = access.getLong(input, off + 8L);
            b2 = access.getLong(input, off + 16L);
            b3 = access.getLong(input, off + 24L);
            b4 = access.getLong(input, off + 32L);
            b5 = access.getLong(input, off + 40L);
            b6 = access.getLong(input, off + 48L);
            b7 = access.getLong(input, off + 56L);
            x = Long.rotateRight(x + y + v0 + b1, 37) * -5435081209227447693L ^ w1;
            y = Long.rotateRight(y + v1 + b6, 42) * -5435081209227447693L + v0 + b5;
            z = Long.rotateRight(z + w0, 33) * -5435081209227447693L;
            v1 *= -5435081209227447693L;
            v0 = (v1 += b0) + (b1 + b2);
            v1 += Long.rotateRight(x + w0 + v1 + b3, 21);
            v1 += Long.rotateRight(v0, 44);
            w0 = (w1 += z + b4) + (b5 + b6);
            w1 += Long.rotateRight(y + w1 + b2 + b7, 21);
            w1 += Long.rotateRight(w0, 44);
            v0 += b3;
            w0 += b7;
            long t = z;
            z = x;
            x = t;
        } while ((off += 64L) != end);
        b0 = access.getLong(input, last64offset);
        b1 = access.getLong(input, last64offset + 8L);
        b2 = access.getLong(input, last64offset + 16L);
        b3 = access.getLong(input, last64offset + 24L);
        b4 = access.getLong(input, last64offset + 32L);
        b5 = access.getLong(input, last64offset + 40L);
        b6 = access.getLong(input, last64offset + 48L);
        b7 = access.getLong(input, last64offset + 56L);
        return this.finalizeHash(x, y, z, v0, v1, w0 += len - 1L & 0x3FL, w1, b0, b1, b2, b3, b4, b5, b6, b7);
    }

    @Override
    protected long hashCharsToLongLength33Plus(CharSequence input) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int len = input.length();
        long x = 95310865018149119L;
        long y = 2480279821605975764L;
        long z = 1390051526045402406L;
        long v0 = 0L;
        long v1 = 0L;
        long w0 = 0L;
        long w1 = 0L;
        int end = len - 1 & 0xFFFFFFE0;
        int last64offset = len - 32;
        x += ByteArrayUtil.getLong(input, 0);
        int offset = 0;
        do {
            b0 = ByteArrayUtil.getLong(input, offset + 0);
            b1 = ByteArrayUtil.getLong(input, offset + 4);
            b2 = ByteArrayUtil.getLong(input, offset + 8);
            b3 = ByteArrayUtil.getLong(input, offset + 12);
            b4 = ByteArrayUtil.getLong(input, offset + 16);
            b5 = ByteArrayUtil.getLong(input, offset + 20);
            b6 = ByteArrayUtil.getLong(input, offset + 24);
            b7 = ByteArrayUtil.getLong(input, offset + 28);
            x = Long.rotateRight(x + y + v0 + b1, 37) * -5435081209227447693L ^ w1;
            y = Long.rotateRight(y + v1 + b6, 42) * -5435081209227447693L + v0 + b5;
            z = Long.rotateRight(z + w0, 33) * -5435081209227447693L;
            v1 *= -5435081209227447693L;
            v0 = (v1 += b0) + (b1 + b2);
            v1 += Long.rotateRight(x + w0 + v1 + b3, 21);
            v1 += Long.rotateRight(v0, 44);
            w0 = (w1 += z + b4) + (b5 + b6);
            w1 += Long.rotateRight(y + w1 + b2 + b7, 21);
            w1 += Long.rotateRight(w0, 44);
            v0 += b3;
            w0 += b7;
            long t = z;
            z = x;
            x = t;
        } while ((offset += 32) != end);
        b0 = ByteArrayUtil.getLong(input, last64offset);
        b1 = ByteArrayUtil.getLong(input, last64offset + 4);
        b2 = ByteArrayUtil.getLong(input, last64offset + 8);
        b3 = ByteArrayUtil.getLong(input, last64offset + 12);
        b4 = ByteArrayUtil.getLong(input, last64offset + 16);
        b5 = ByteArrayUtil.getLong(input, last64offset + 20);
        b6 = ByteArrayUtil.getLong(input, last64offset + 24);
        b7 = ByteArrayUtil.getLong(input, last64offset + 28);
        return this.finalizeHash(x, y, z, v0, v1, w0 += (long)((len << 1) - 1 & 0x3F), w1, b0, b1, b2, b3, b4, b5, b6, b7);
    }

    private long finalizeHash(long x, long y, long z, long v0, long v1, long w0, long w1, long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
        long mul = -5435081209227447693L + ((z & 0xFFL) << 1);
        v0 += w0;
        x = Long.rotateRight(x + y + v0 + b1, 37) * mul;
        y = Long.rotateRight(y + v1 + b6, 42) * mul;
        z = Long.rotateRight(z + (w0 += v0), 33) * mul;
        long c0 = v1 * mul + b0;
        long a0 = c0 + (b1 + b2);
        long c1 = z + w1 + b4;
        long a1 = c1 + (b5 + b6);
        return this.finalizeHash(FarmHashNa.hashLen16(FarmHashNa.hashLen16(a0 + b3, a1 + b7, mul) + FarmHashNa.shiftMix(y += v0 * 9L + b5) * -4348849565147123417L + (x ^= w1 * 9L), FarmHashNa.hashLen16(Long.rotateRight(x + w0 + c0 + b3, 21) + Long.rotateRight(a0, 44) + c0, Long.rotateRight(y + b2 + c1 + b7, 21) + Long.rotateRight(a1, 44) + c1, mul) + z, mul));
    }

    private static final class FarmHashNaWithSeeds
    extends FarmHashNa {
        private final long seed0;
        private final long seed1;

        private FarmHashNaWithSeeds(long seed0, long seed1) {
            this.seed0 = seed0;
            this.seed1 = seed1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FarmHashNaWithSeeds)) {
                return false;
            }
            FarmHashNaWithSeeds that = (FarmHashNaWithSeeds)obj;
            return this.seed0 == that.seed0 && this.seed1 == that.seed1;
        }

        public int hashCode() {
            return Objects.hash(this.seed0, this.seed1);
        }

        @Override
        protected long finalizeHash(long hash) {
            return FarmHashNaWithSeeds.hashLen16(hash - this.seed0, this.seed1, -7070675565921424023L);
        }
    }

    private class HashStreamImpl
    extends AbstractFarmHash.FarmHashStreamImpl {
        private long x = 95310865018149119L;
        private long y = 2480279821605975764L;
        private long z = 1390051526045402406L;
        private long v0 = 0L;
        private long v1 = 0L;
        private long w0 = 0L;
        private long w1 = 0L;
        private static final byte SERIAL_VERSION_V0 = 0;

        private HashStreamImpl() {
        }

        public boolean equals(Object obj) {
            return HashUtil.equalsHelper(this, obj);
        }

        public int hashCode() {
            return this.getAsInt();
        }

        @Override
        public HashStream64 reset() {
            this.x = 95310865018149119L;
            this.y = 2480279821605975764L;
            this.z = 1390051526045402406L;
            this.v0 = 0L;
            this.v1 = 0L;
            this.w0 = 0L;
            this.w1 = 0L;
            this.bufferCount = 8;
            this.init = true;
            return this;
        }

        @Override
        public Hasher64 getHasher() {
            return FarmHashNa.this;
        }

        @Override
        public byte[] getState() {
            int numBufferBytes = this.init ? this.bufferCount - 8 : 64;
            byte[] state = new byte[2 + (this.init ? 0 : 56) + numBufferBytes];
            state[0] = 0;
            int off = 1;
            state[off++] = (byte)(this.bufferCount - 8 | (this.init ? 128 : 0));
            if (!this.init) {
                ByteArrayUtil.setLong(state, off, this.x);
                ByteArrayUtil.setLong(state, off += 8, this.y);
                ByteArrayUtil.setLong(state, off += 8, this.z);
                ByteArrayUtil.setLong(state, off += 8, this.v0);
                ByteArrayUtil.setLong(state, off += 8, this.v1);
                ByteArrayUtil.setLong(state, off += 8, this.w0);
                ByteArrayUtil.setLong(state, off += 8, this.w1);
                off += 8;
            }
            System.arraycopy(this.buffer, 8, state, off, numBufferBytes);
            return state;
        }

        @Override
        public HashStream64 setState(byte[] state) {
            Preconditions.checkArgument(state != null);
            Preconditions.checkArgument(state.length >= 2);
            Preconditions.checkArgument(state[0] == 0);
            int off = 1;
            byte b = state[off++];
            this.bufferCount = 8 + (b & 0x7F);
            this.init = b < 0;
            Preconditions.checkArgument(this.bufferCount >= 9 && this.bufferCount <= 72 || this.bufferCount == 8 && this.init);
            int numBufferBytes = this.init ? this.bufferCount - 8 : 64;
            Preconditions.checkArgument(state.length == 2 + (this.init ? 0 : 56) + numBufferBytes);
            if (!this.init) {
                this.x = ByteArrayUtil.getLong(state, off);
                this.y = ByteArrayUtil.getLong(state, off += 8);
                this.z = ByteArrayUtil.getLong(state, off += 8);
                this.v0 = ByteArrayUtil.getLong(state, off += 8);
                this.v1 = ByteArrayUtil.getLong(state, off += 8);
                this.w0 = ByteArrayUtil.getLong(state, off += 8);
                this.w1 = ByteArrayUtil.getLong(state, off += 8);
                off += 8;
            } else {
                this.x = 95310865018149119L;
                this.y = 2480279821605975764L;
                this.z = 1390051526045402406L;
                this.v0 = 0L;
                this.v1 = 0L;
                this.w0 = 0L;
                this.w1 = 0L;
            }
            System.arraycopy(state, off, this.buffer, 8, numBufferBytes);
            return this;
        }

        @Override
        protected void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
            if (this.init) {
                this.x += b0;
            }
            this.init = false;
            this.x = Long.rotateRight(this.x + this.y + this.v0 + b1, 37) * -5435081209227447693L ^ this.w1;
            this.y = Long.rotateRight(this.y + this.v1 + b6, 42) * -5435081209227447693L + this.v0 + b5;
            this.z = Long.rotateRight(this.z + this.w0, 33) * -5435081209227447693L;
            this.v1 *= -5435081209227447693L;
            this.v1 += b0;
            this.v0 = this.v1 + (b1 + b2);
            this.v1 += Long.rotateRight(this.x + this.w0 + this.v1 + b3, 21);
            this.v1 += Long.rotateRight(this.v0, 44);
            this.w1 += this.z + b4;
            this.w0 = this.w1 + (b5 + b6);
            this.w1 += Long.rotateRight(this.y + this.w1 + b2 + b7, 21);
            this.w1 += Long.rotateRight(this.w0, 44);
            this.v0 += b3;
            this.w0 += b7;
            long t = this.z;
            this.z = this.x;
            this.x = t;
        }

        @Override
        public long getAsLong() {
            if (this.init) {
                if (this.bufferCount <= 40) {
                    if (this.bufferCount <= 24) {
                        return FarmHashNa.this.finalizeHash(this.hashLen0To16(this.bufferCount));
                    }
                    return FarmHashNa.this.finalizeHash(this.hashLen17To32(this.bufferCount));
                }
                return FarmHashNa.this.finalizeHash(this.hashLen33To64(this.bufferCount));
            }
            ByteArrayUtil.setLong(this.buffer, 0, ByteArrayUtil.getLong(this.buffer, 64));
            long b0 = ByteArrayUtil.getLong(this.buffer, this.bufferCount & 0x3F);
            long b1 = ByteArrayUtil.getLong(this.buffer, this.bufferCount + 8 & 0x3F);
            long b2 = ByteArrayUtil.getLong(this.buffer, this.bufferCount + 16 & 0x3F);
            long b3 = ByteArrayUtil.getLong(this.buffer, this.bufferCount + 24 & 0x3F);
            long b4 = ByteArrayUtil.getLong(this.buffer, this.bufferCount + 32 & 0x3F);
            long b5 = ByteArrayUtil.getLong(this.buffer, this.bufferCount + 40 & 0x3F);
            long b6 = ByteArrayUtil.getLong(this.buffer, this.bufferCount + 48 & 0x3F);
            long b7 = ByteArrayUtil.getLong(this.buffer, this.bufferCount - 8);
            return FarmHashNa.this.finalizeHash(this.x, this.y, this.z, this.v0, this.v1, this.w0 + (long)this.bufferCount - 9L, this.w1, b0, b1, b2, b3, b4, b5, b6, b7);
        }
    }

    private static final class FarmHashNaWithoutSeed
    extends FarmHashNa {
        private FarmHashNaWithoutSeed() {
        }

        public boolean equals(Object obj) {
            return obj instanceof FarmHashNaWithoutSeed;
        }

        public int hashCode() {
            return -387763911;
        }
    }
}

