/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DetectableIndentOptionsProvider;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.ec4j.core.ResourceProperties;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigActionUtil;
import org.editorconfig.configmanagement.EditorConfigIndentStatusBarUIContributor;
import org.editorconfig.plugincomponents.EditorConfigPropertiesService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J*\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002JB\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0002J \u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001aH\u0002\u00a8\u0006'"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigIndentOptionsProvider;", "Lcom/intellij/psi/codeStyle/FileIndentOptionsProvider;", "<init>", "()V", "getIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getActivatingAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "activeUiContributor", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleStatusBarUIContributor;", "Lcom/intellij/psi/PsiFile;", "getIndentStatusBarUiContributor", "Lcom/intellij/psi/codeStyle/IndentStatusBarUIContributor;", "indentOptions", "applyCodeStyleSettings", "properties", "Lorg/ec4j/core/ResourceProperties;", "applyIndentOptions", "", "indentSize", "", "continuationIndentSize", "tabWidth", "indentStyle", "filePath", "calculateIndentSize", "options", "calculateContinuationIndentSize", "calculateTabWidth", "applyIndentSize", "applyContinuationIndentSize", "applyTabWidth", "applyIndentStyle", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigIndentOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigIndentOptionsProvider.kt\norg/editorconfig/configmanagement/EditorConfigIndentOptionsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class EditorConfigIndentOptionsProvider
extends FileIndentOptionsProvider {
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project, @NotNull CodeStyleSettings settings, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Utils.INSTANCE.isFullIntellijSettingsSupport()) {
            return null;
        }
        if (project.isDisposed() || !Utils.isEnabled(settings)) {
            return null;
        }
        ResourceProperties properties = EditorConfigPropertiesService.Companion.getInstance(project).getProperties(file);
        return this.applyCodeStyleSettings(project, properties, file, settings);
    }

    @Nullable
    public AnAction getActivatingAction(@Nullable CodeStyleStatusBarUIContributor activeUiContributor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Utils.INSTANCE.isFullIntellijSettingsSupport() && (activeUiContributor == null || DetectableIndentOptionsProvider.isIndentDetectionContributor((CodeStyleStatusBarUIContributor)activeUiContributor))) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!Utils.isEnabled(project) && Utils.INSTANCE.hasEditorConfig(file)) {
                return (AnAction)DumbAwareAction.create((String)EditorConfigBundle.message((String)"action.enable"), arg_0 -> EditorConfigIndentOptionsProvider.getActivatingAction$lambda$1(arg_0 -> EditorConfigIndentOptionsProvider.getActivatingAction$lambda$0(file, arg_0), arg_0));
            }
        }
        return null;
    }

    @NotNull
    public IndentStatusBarUIContributor getIndentStatusBarUiContributor(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        return new EditorConfigIndentStatusBarUIContributor(indentOptions);
    }

    private final CommonCodeStyleSettings.IndentOptions applyCodeStyleSettings(Project project, ResourceProperties properties, VirtualFile file, CodeStyleSettings settings) {
        String indentSize = Utils.INSTANCE.configValueForKey(properties, "indent_size");
        String continuationIndentSize = Utils.INSTANCE.configValueForKey(properties, "continuation_indent_size");
        String tabWidth = Utils.INSTANCE.configValueForKey(properties, "tab_width");
        String indentStyle = Utils.INSTANCE.configValueForKey(properties, "indent_style");
        Object object = settings.getIndentOptions(file.getFileType()).clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.codeStyle.CommonCodeStyleSettings.IndentOptions");
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)object;
        if (this.applyIndentOptions(project, indentOptions, indentSize, continuationIndentSize, tabWidth, indentStyle, file.getCanonicalPath())) {
            indentOptions.setOverrideLanguageOptions(true);
            return indentOptions;
        }
        return null;
    }

    private final boolean applyIndentOptions(Project project, CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize, String continuationIndentSize, String tabWidth, String indentStyle, String filePath) {
        boolean changed = false;
        String calculatedIndentSize = this.calculateIndentSize(tabWidth, indentSize, indentOptions);
        String calculatedContinuationSize = this.calculateContinuationIndentSize(calculatedIndentSize, continuationIndentSize);
        String calculatedTabWidth = this.calculateTabWidth(tabWidth, indentSize);
        if (!(((CharSequence)calculatedIndentSize).length() == 0)) {
            if (this.applyIndentSize(indentOptions, calculatedIndentSize)) {
                changed = true;
            } else {
                Utils.INSTANCE.invalidConfigMessage(project, calculatedIndentSize, "indent_size", filePath);
            }
        }
        if (!(((CharSequence)calculatedContinuationSize).length() == 0)) {
            if (this.applyContinuationIndentSize(indentOptions, calculatedContinuationSize)) {
                changed = true;
            } else {
                Utils.INSTANCE.invalidConfigMessage(project, calculatedIndentSize, "indent_size", filePath);
            }
        }
        if (!(((CharSequence)calculatedTabWidth).length() == 0)) {
            if (this.applyTabWidth(indentOptions, calculatedTabWidth)) {
                changed = true;
            } else {
                Utils.INSTANCE.invalidConfigMessage(project, calculatedTabWidth, "tab_width", filePath);
            }
        }
        if (!(((CharSequence)indentStyle).length() == 0)) {
            if (this.applyIndentStyle(indentOptions, indentStyle)) {
                changed = true;
            } else {
                Utils.INSTANCE.invalidConfigMessage(project, indentStyle, "indent_style", filePath);
            }
        }
        return changed;
    }

    private final String calculateIndentSize(String tabWidth, String indentSize, CommonCodeStyleSettings.IndentOptions options) {
        String string;
        if (Intrinsics.areEqual((Object)indentSize, (Object)"tab")) {
            CharSequence charSequence;
            CharSequence charSequence2 = tabWidth;
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = String.valueOf(options.TAB_SIZE);
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        } else {
            string = indentSize;
        }
        return string;
    }

    private final String calculateContinuationIndentSize(String indentSize, String continuationIndentSize) {
        CharSequence charSequence;
        CharSequence charSequence2 = continuationIndentSize;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = indentSize;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private final String calculateTabWidth(String tabWidth, String indentSize) {
        return ((CharSequence)tabWidth).length() == 0 && Intrinsics.areEqual((Object)indentSize, (Object)"tab") ? "" : (((CharSequence)tabWidth).length() == 0 ? indentSize : tabWidth);
    }

    private final boolean applyIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String indentSize) {
        boolean bl;
        Integer n = StringsKt.toIntOrNull((String)indentSize);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            indentOptions.INDENT_SIZE = it;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean applyContinuationIndentSize(CommonCodeStyleSettings.IndentOptions indentOptions, String continuationIndentSize) {
        boolean bl;
        Integer n = StringsKt.toIntOrNull((String)continuationIndentSize);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            indentOptions.CONTINUATION_INDENT_SIZE = it;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean applyTabWidth(CommonCodeStyleSettings.IndentOptions indentOptions, String tabWidth) {
        boolean bl;
        Integer n = StringsKt.toIntOrNull((String)tabWidth);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            indentOptions.TAB_SIZE = it;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean applyIndentStyle(CommonCodeStyleSettings.IndentOptions indentOptions, String indentStyle) {
        if (Intrinsics.areEqual((Object)indentStyle, (Object)"tab") || Intrinsics.areEqual((Object)indentStyle, (Object)"space")) {
            indentOptions.USE_TAB_CHARACTER = Intrinsics.areEqual((Object)indentStyle, (Object)"tab");
            return true;
        }
        return false;
    }

    private static final Unit getActivatingAction$lambda$0(PsiFile $file, AnActionEvent it) {
        EditorConfigActionUtil.setEditorConfigEnabled($file.getProject(), true);
        return Unit.INSTANCE;
    }

    private static final void getActivatingAction$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

