/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.settings;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.security.spi.resources.client.ResourceSharingClient;

public class ResourceSharingFeatureFlagSetting
extends OpensearchDynamicSetting<Boolean> {
    private static final Logger logger = LogManager.getLogger(ResourceSharingFeatureFlagSetting.class);
    public static final Setting<Boolean> RESOURCE_SHARING_ENABLED = Setting.boolSetting((String)"plugins.security.experimental.resource_sharing.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ResourcePluginInfo resourcePluginInfo;

    public ResourceSharingFeatureFlagSetting(Settings settings, ResourcePluginInfo resourcePluginInfo) {
        super(RESOURCE_SHARING_ENABLED, (Boolean)RESOURCE_SHARING_ENABLED.get(settings));
        this.resourcePluginInfo = resourcePluginInfo;
    }

    @Override
    public void registerClusterSettingsChangeListener(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(RESOURCE_SHARING_ENABLED, isEnabled -> {
            logger.info(this.getClusterChangeMessage((Boolean)isEnabled));
            this.setDynamicSettingValue(isEnabled);
            if (isEnabled.booleanValue()) {
                ResourceSharingClient client = this.resourcePluginInfo.getResourceAccessControlClient();
                this.resourcePluginInfo.getResourceSharingExtensions().forEach(ext -> ext.assignResourceSharingClient(client));
            } else {
                this.resourcePluginInfo.getResourceSharingExtensions().forEach(ext -> ext.assignResourceSharingClient(null));
            }
        });
    }

    @Override
    protected String getClusterChangeMessage(Boolean isEnabled) {
        return String.format("Detected change in settings, cluster setting for resource-sharing feature flag is %s", isEnabled != false ? "enabled" : "disabled");
    }
}

