/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ltr;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CacheStat
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CacheStat> {
    @Nullable
    private final Integer entryCount;
    @Nullable
    private final Integer evictionCount;
    @Nullable
    private final Integer hitCount;
    @Nullable
    private final Integer memoryUsageInBytes;
    @Nullable
    private final Integer missCount;
    public static final JsonpDeserializer<CacheStat> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CacheStat::setupCacheStatDeserializer);

    private CacheStat(Builder builder) {
        this.entryCount = builder.entryCount;
        this.evictionCount = builder.evictionCount;
        this.hitCount = builder.hitCount;
        this.memoryUsageInBytes = builder.memoryUsageInBytes;
        this.missCount = builder.missCount;
    }

    public static CacheStat of(Function<Builder, ObjectBuilder<CacheStat>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer entryCount() {
        return this.entryCount;
    }

    @Nullable
    public final Integer evictionCount() {
        return this.evictionCount;
    }

    @Nullable
    public final Integer hitCount() {
        return this.hitCount;
    }

    @Nullable
    public final Integer memoryUsageInBytes() {
        return this.memoryUsageInBytes;
    }

    @Nullable
    public final Integer missCount() {
        return this.missCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.entryCount != null) {
            generator.writeKey("entry_count");
            generator.write(this.entryCount.intValue());
        }
        if (this.evictionCount != null) {
            generator.writeKey("eviction_count");
            generator.write(this.evictionCount.intValue());
        }
        if (this.hitCount != null) {
            generator.writeKey("hit_count");
            generator.write(this.hitCount.intValue());
        }
        if (this.memoryUsageInBytes != null) {
            generator.writeKey("memory_usage_in_bytes");
            generator.write(this.memoryUsageInBytes.intValue());
        }
        if (this.missCount != null) {
            generator.writeKey("miss_count");
            generator.write(this.missCount.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCacheStatDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::entryCount, JsonpDeserializer.integerDeserializer(), "entry_count");
        op.add(Builder::evictionCount, JsonpDeserializer.integerDeserializer(), "eviction_count");
        op.add(Builder::hitCount, JsonpDeserializer.integerDeserializer(), "hit_count");
        op.add(Builder::memoryUsageInBytes, JsonpDeserializer.integerDeserializer(), "memory_usage_in_bytes");
        op.add(Builder::missCount, JsonpDeserializer.integerDeserializer(), "miss_count");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.entryCount);
        result = 31 * result + Objects.hashCode(this.evictionCount);
        result = 31 * result + Objects.hashCode(this.hitCount);
        result = 31 * result + Objects.hashCode(this.memoryUsageInBytes);
        result = 31 * result + Objects.hashCode(this.missCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheStat other = (CacheStat)o;
        return Objects.equals(this.entryCount, other.entryCount) && Objects.equals(this.evictionCount, other.evictionCount) && Objects.equals(this.hitCount, other.hitCount) && Objects.equals(this.memoryUsageInBytes, other.memoryUsageInBytes) && Objects.equals(this.missCount, other.missCount);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CacheStat> {
        @Nullable
        private Integer entryCount;
        @Nullable
        private Integer evictionCount;
        @Nullable
        private Integer hitCount;
        @Nullable
        private Integer memoryUsageInBytes;
        @Nullable
        private Integer missCount;

        public Builder() {
        }

        private Builder(CacheStat o) {
            this.entryCount = o.entryCount;
            this.evictionCount = o.evictionCount;
            this.hitCount = o.hitCount;
            this.memoryUsageInBytes = o.memoryUsageInBytes;
            this.missCount = o.missCount;
        }

        private Builder(Builder o) {
            this.entryCount = o.entryCount;
            this.evictionCount = o.evictionCount;
            this.hitCount = o.hitCount;
            this.memoryUsageInBytes = o.memoryUsageInBytes;
            this.missCount = o.missCount;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder entryCount(@Nullable Integer value) {
            this.entryCount = value;
            return this;
        }

        @Nonnull
        public final Builder evictionCount(@Nullable Integer value) {
            this.evictionCount = value;
            return this;
        }

        @Nonnull
        public final Builder hitCount(@Nullable Integer value) {
            this.hitCount = value;
            return this;
        }

        @Nonnull
        public final Builder memoryUsageInBytes(@Nullable Integer value) {
            this.memoryUsageInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder missCount(@Nullable Integer value) {
            this.missCount = value;
            return this;
        }

        @Override
        @Nonnull
        public CacheStat build() {
            this._checkSingleUse();
            return new CacheStat(this);
        }
    }
}

