/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.CorePropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NestedProperty
extends CorePropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, NestedProperty> {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final Boolean includeInParent;
    @Nullable
    private final Boolean includeInRoot;
    public static final JsonpDeserializer<NestedProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedProperty::setupNestedPropertyDeserializer);

    private NestedProperty(Builder builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.includeInParent = builder.includeInParent;
        this.includeInRoot = builder.includeInRoot;
    }

    public static NestedProperty of(Function<Builder, ObjectBuilder<NestedProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Nested;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final Boolean includeInParent() {
        return this.includeInParent;
    }

    @Nullable
    public final Boolean includeInRoot() {
        return this.includeInRoot;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nested");
        super.serializeInternal(generator, mapper);
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.includeInParent != null) {
            generator.writeKey("include_in_parent");
            generator.write(this.includeInParent.booleanValue());
        }
        if (this.includeInRoot != null) {
            generator.writeKey("include_in_root");
            generator.write(this.includeInRoot.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNestedPropertyDeserializer(ObjectDeserializer<Builder> op) {
        NestedProperty.setupCorePropertyBaseDeserializer(op);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::includeInParent, JsonpDeserializer.booleanDeserializer(), "include_in_parent");
        op.add(Builder::includeInRoot, JsonpDeserializer.booleanDeserializer(), "include_in_root");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.enabled);
        result = 31 * result + Objects.hashCode(this.includeInParent);
        result = 31 * result + Objects.hashCode(this.includeInRoot);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedProperty other = (NestedProperty)o;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.includeInParent, other.includeInParent) && Objects.equals(this.includeInRoot, other.includeInRoot);
    }

    public static class Builder
    extends CorePropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NestedProperty> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private Boolean includeInParent;
        @Nullable
        private Boolean includeInRoot;

        public Builder() {
        }

        private Builder(NestedProperty o) {
            super(o);
            this.enabled = o.enabled;
            this.includeInParent = o.includeInParent;
            this.includeInRoot = o.includeInRoot;
        }

        private Builder(Builder o) {
            super(o);
            this.enabled = o.enabled;
            this.includeInParent = o.includeInParent;
            this.includeInRoot = o.includeInRoot;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public final Builder includeInParent(@Nullable Boolean value) {
            this.includeInParent = value;
            return this;
        }

        @Nonnull
        public final Builder includeInRoot(@Nullable Boolean value) {
            this.includeInRoot = value;
            return this;
        }

        @Override
        @Nonnull
        public NestedProperty build() {
            this._checkSingleUse();
            return new NestedProperty(this);
        }
    }
}

