/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.breaker;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.breaker.BreakerName;
import org.opensearch.ml.breaker.CircuitBreaker;
import org.opensearch.ml.breaker.DiskCircuitBreaker;
import org.opensearch.ml.breaker.MemoryCircuitBreaker;
import org.opensearch.ml.breaker.ThresholdCircuitBreaker;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.monitor.os.OsService;

public class MLCircuitBreakerService {
    @Generated
    private static final Logger log = LogManager.getLogger(MLCircuitBreakerService.class);
    private final ConcurrentMap<BreakerName, CircuitBreaker> breakers = new ConcurrentHashMap<BreakerName, CircuitBreaker>();
    private final JvmService jvmService;
    private final OsService osService;
    private final Settings settings;
    private final ClusterService clusterService;

    public MLCircuitBreakerService(JvmService jvmService, OsService osService, Settings settings, ClusterService clusterService) {
        this.jvmService = jvmService;
        this.osService = osService;
        this.settings = settings;
        this.clusterService = clusterService;
    }

    public void registerBreaker(BreakerName name, CircuitBreaker breaker) {
        this.breakers.putIfAbsent(name, breaker);
    }

    public void unregisterBreaker(BreakerName name) {
        if (name == null) {
            return;
        }
        this.breakers.remove((Object)name);
        log.info("Removed ML breakers " + String.valueOf((Object)name));
    }

    public void clearBreakers() {
        this.breakers.clear();
        log.info("Cleared ML breakers.");
    }

    public CircuitBreaker getBreaker(BreakerName name) {
        return (CircuitBreaker)this.breakers.get((Object)name);
    }

    public MLCircuitBreakerService init(Path path) {
        this.registerBreaker(BreakerName.MEMORY, new MemoryCircuitBreaker(this.settings, this.clusterService, this.jvmService));
        log.info("Registered ML memory breaker.");
        this.registerBreaker(BreakerName.DISK, new DiskCircuitBreaker(this.settings, this.clusterService, new File(path.toString())));
        log.info("Registered ML disk breaker.");
        log.info("Registered ML native memory breaker.");
        return this;
    }

    public ThresholdCircuitBreaker checkOpenCB() {
        for (CircuitBreaker breaker : this.breakers.values()) {
            if (!breaker.isOpen()) continue;
            return (ThresholdCircuitBreaker)breaker;
        }
        return null;
    }
}

