/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xps;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.ooxml.extractor.POIXMLTextExtractor;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.ZipPackage;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.xps.XPSPageContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XPSExtractorDecorator
extends AbstractOOXMLExtractor {
    private static final String OPEN_XPS_DOCUMENT = "http://schemas.openxps.org/oxps/v1.0/fixedrepresentation";
    private static String XPS_DOCUMENT = "http://schemas.microsoft.com/xps/2005/06/fixedrepresentation";
    private final ParseContext context;
    private final ZipPackage pkg;
    Map<String, Metadata> embeddedImages = new LinkedHashMap<String, Metadata>();

    public XPSExtractorDecorator(ParseContext context, POIXMLTextExtractor extractor) throws TikaException {
        super(context, extractor);
        this.context = context;
        if (!(extractor.getPackage() instanceof ZipPackage)) {
            throw new TikaException("OPCPackage must be a ZipPackage");
        }
        this.pkg = (ZipPackage)extractor.getPackage();
    }

    private static InputStream getZipStream(String zipPath, ZipPackage zipPackage) throws IOException, TikaException {
        String targPath = zipPath.length() > 1 && zipPath.startsWith("/") ? zipPath.substring(1) : zipPath;
        ZipEntrySource zipEntrySource = zipPackage.getZipArchive();
        Enumeration zipEntryEnumeration = zipEntrySource.getEntries();
        ZipArchiveEntry zipEntry = null;
        while (zipEntryEnumeration.hasMoreElements()) {
            ZipArchiveEntry ze = (ZipArchiveEntry)zipEntryEnumeration.nextElement();
            if (!ze.getName().equals(targPath)) continue;
            zipEntry = ze;
            break;
        }
        if (zipEntry == null) {
            throw new TikaException("Couldn't find required zip entry: " + zipPath);
        }
        return zipEntrySource.getInputStream(zipEntry);
    }

    @Override
    public POIXMLDocument getDocument() {
        return null;
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, IOException {
        PackageRelationshipCollection prc = this.pkg.getRelationshipsByType(XPS_DOCUMENT);
        if (prc.size() == 0) {
            prc = this.pkg.getRelationshipsByType(OPEN_XPS_DOCUMENT);
        }
        for (int i = 0; i < prc.size(); ++i) {
            PackageRelationship pr = prc.getRelationship(i);
            try {
                this.handleDocuments(pr, xhtml);
                continue;
            }
            catch (TikaException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
        if (this.embeddedImages.size() > 0) {
            EmbeddedDocumentUtil embeddedDocumentUtil = new EmbeddedDocumentUtil(this.context);
            for (Map.Entry<String, Metadata> embeddedImage : this.embeddedImages.entrySet()) {
                String zipPath = embeddedImage.getKey();
                Metadata metadata = embeddedImage.getValue();
                if (!embeddedDocumentUtil.shouldParseEmbedded(metadata)) continue;
                this.handleEmbeddedImage(zipPath, metadata, embeddedDocumentUtil, xhtml);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEmbeddedImage(String zipPath, Metadata metadata, EmbeddedDocumentUtil embeddedDocumentUtil, XHTMLContentHandler xhtml) throws SAXException, IOException {
        InputStream stream = null;
        try {
            stream = XPSExtractorDecorator.getZipStream(zipPath, this.pkg);
        }
        catch (IOException | TikaException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)metadata);
            return;
        }
        try {
            embeddedDocumentUtil.parseEmbedded(stream, (ContentHandler)xhtml, metadata, true);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private void handleDocuments(PackageRelationship packageRelationship, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        try (InputStream stream = this.pkg.getPart(packageRelationship).getInputStream();){
            XMLReaderUtils.parseSAX((InputStream)CloseShieldInputStream.wrap((InputStream)stream), (ContentHandler)new EmbeddedContentHandler((ContentHandler)new FixedDocSeqHandler(xhtml)), (ParseContext)this.context);
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        return Collections.EMPTY_LIST;
    }

    private class FixedDocSeqHandler
    extends DefaultHandler {
        private static final String DOCUMENT_REFERENCE = "DocumentReference";
        private static final String SOURCE = "Source";
        private final XHTMLContentHandler xhtml;

        private FixedDocSeqHandler(XHTMLContentHandler xhtml) {
            this.xhtml = xhtml;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (!DOCUMENT_REFERENCE.equals(localName)) {
                return;
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                String lName = atts.getLocalName(i);
                if (!SOURCE.equals(lName)) continue;
                this.handleDocumentRef(atts.getValue(i));
            }
        }

        private void handleDocumentRef(String docRef) throws SAXException {
            block9: {
                String zipPath;
                String relativeRoot = null;
                int i = docRef.lastIndexOf("/");
                relativeRoot = i > 0 ? docRef.substring(0, i) : "";
                String string = zipPath = docRef.startsWith("/") ? docRef.substring(1) : docRef;
                if (XPSExtractorDecorator.this.pkg instanceof ZipPackage) {
                    try (InputStream stream = XPSExtractorDecorator.getZipStream(zipPath, XPSExtractorDecorator.this.pkg);){
                        XMLReaderUtils.parseSAX((InputStream)CloseShieldInputStream.wrap((InputStream)stream), (ContentHandler)new EmbeddedContentHandler((ContentHandler)new PageContentPartHandler(relativeRoot, this.xhtml)), (ParseContext)XPSExtractorDecorator.this.context);
                        break block9;
                    }
                    catch (IOException | TikaException e) {
                        throw new SAXException((Exception)((Object)new TikaException("IOException trying to read: " + docRef)));
                    }
                }
                throw new SAXException((Exception)((Object)new TikaException("Package must be ZipPackage")));
            }
        }

        private class PageContentPartHandler
        extends DefaultHandler {
            private static final String PAGE_CONTENT = "PageContent";
            private static final String SOURCE = "Source";
            private final String relativeRoot;
            private final XHTMLContentHandler xhtml;

            private PageContentPartHandler(String relativeRoot, XHTMLContentHandler xhtml) {
                this.relativeRoot = relativeRoot;
                this.xhtml = xhtml;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                if (!PAGE_CONTENT.equals(localName)) {
                    return;
                }
                Object pagePath = null;
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (!"Source".equals(atts.getLocalName(i))) continue;
                    pagePath = atts.getValue(i);
                    break;
                }
                if (pagePath != null) {
                    if (!((String)pagePath).startsWith("/")) {
                        pagePath = this.relativeRoot + "/" + (String)pagePath;
                    }
                    if (((String)pagePath).startsWith("/")) {
                        pagePath = ((String)pagePath).substring(1);
                    }
                    try (InputStream stream = XPSExtractorDecorator.getZipStream((String)pagePath, XPSExtractorDecorator.this.pkg);){
                        XMLReaderUtils.parseSAX((InputStream)CloseShieldInputStream.wrap((InputStream)stream), (ContentHandler)new XPSPageContentHandler(this.xhtml, XPSExtractorDecorator.this.embeddedImages), (ParseContext)XPSExtractorDecorator.this.context);
                    }
                    catch (IOException | TikaException e) {
                        throw new SAXException((Exception)e);
                    }
                }
            }
        }
    }
}

