"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatPlugin = void 0;
var _operators = require("rxjs/operators");
var _routes = require("./routes");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
/**
 * @experimental
 * Chat plugin for AI-powered interactions. This plugin is experimental and will change in future releases.
 */
class ChatPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "config$", void 0);
    _defineProperty(this, "capabilitiesResolver", void 0);
    this.logger = initializerContext.logger.get();
    this.config$ = initializerContext.config.create();
  }
  async setup(core) {
    this.logger.debug('chat: Setup');
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const router = core.http.createRouter();
    const getCapabilitiesResolver = () => this.capabilitiesResolver;

    // Register capability to indicate observability agent availability
    core.capabilities.registerProvider(() => ({
      chat: {
        observabilityAgentEnabled: !!config.observabilityAgentId
      }
    }));
    (0, _routes.defineRoutes)(router, this.logger, config.agUiUrl, getCapabilitiesResolver, config.mlCommonsAgentId, config.observabilityAgentId);
    return {};
  }
  start(core) {
    this.logger.debug('chat: Started');
    this.capabilitiesResolver = request => core.capabilities.resolveCapabilities(request);
    return {};
  }
  stop() {}
}
exports.ChatPlugin = ChatPlugin;