"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = render;
var _reactDomClient = require("./react-dom-client");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// eslint-disable-next-line import/no-unresolved

/**
 * Version-agnostic render function that works with both React 16 and 18
 * In React 16, it uses our shim for react-dom/client (./react-dom-client.ts)
 * In React 18, we can alias this file to the actual react-dom/client
 */
function render(element, container) {
  var root = (0, _reactDomClient.createRoot)(container);
  root.render(element);
  return root;
}